local S = minetest.get_translator(minetest.get_current_modname())

better_commands.entity_aliases = {
    -- Animalia
    ["animalia:angelfish"] = {angelfish = true},
    ["animalia:bat"] = {bat = true},
    ["animalia:bird"] = {bird = true},
    ["animalia:blue_tang"] = {blue_tang = true},
    ["animalia:cat"] = {cat = true},
    ["animalia:chicken"] = {chicken = true},
    ["animalia:clownfish"] = {clownfish = true},
    ["animalia:cow"] = {cow = true},
    ["animalia:fox"] = {fox = true},
    ["animalia:frog"] = {frog = true},
    ["animalia:grizzly_bear"] = {grizzly_bear = true},
    ["animalia:horse"] = {horse = true},
    ["animalia:opossum"] = {opossom = true, possum = true},
    ["animalia:owl"] = {owl = true},
    ["animalia:pig"] = {pig = true},
    ["animalia:rat"] = {rat = true},
    ["animalia:reindeer"] = {reindeer = true},
    ["animalia:sheep"] = {sheep = true},
    ["animalia:song_bird"] = {song_bird = true, songbird = true},
    ["animalia:tropical_fish"] = {tropical_fish = true},
    ["animalia:turkey"] = {turkey = true},
    ["animalia:wolf"] = {wolf = true},

    -- Built-in:
    ["__builtin:item"] = {item = true},
    ["__builtin:falling_node"] = {falling_node = true, falling_block = true},

    -- Dmobs
    ["dmobs:badger"] = {badger = true},
    ["dmobs:butterfly"] = {butterfly = true},
    ["dmobs:dragon1"] = {dragon = true, dragon1 = true, red_dragon = true, fire_dragon = true},
    ["dmobs:dragon2"] = {dragon = true, dragon2 = true, black_dragon = true, lightning_dragon = true},
    ["dmobs:dragon3"] = {dragon = true, dragon3 = true, green_dragon = true, poison_dragon = true},
    ["dmobs:dragon4"] = {dragon = true, dragon4 = true, blue_dragon = true, ice_dragon = true},
    ["dmobs:dragon_black"] = {dragon = true, dragon2 = true, black_dragon = true, lightning_dragon = true},
    ["dmobs:dragon_blue"] = {dragon = true, dragon4 = true, blue_dragon = true, ice_dragon = true},
    ["dmobs:dragon_great"] = {dragon = true, boss_dragon = true, great_dragon = true},
    ["dmobs:dragon_green"] = {dragon = true, dragon3 = true, green_dragon = true, poison_dragon = true},
    ["dmobs:dragon_red"] = {dragon = true, dragon1 = true, red_dragon = true, fire_dragon = true},
    ["dmobs:elephant"] = {elephant = true},
    ["dmobs:fox"] = {fox = true},
    ["dmobs:gnorm"] = {gnorm = true},
    ["dmobs:golem"] = {golem = true},
    ["dmobs:golem_friendly"] = {golem = true},
    ["dmobs:hedgehog"] = {hedgehog = true},
    ["dmobs:nyan"] = {nyan = true, nyan_cat = true},
    ["dmobs:ogre"] = {ogre = true},
    ["dmobs:orc"] = {orc = true},
    ["dmobs:orc2"] = {orc = true, orc2 = true, morgul_orc = true},
    ["dmobs:owl"] = {owl = true},
    ["dmobs:panda"] = {panda = true},
    ["dmobs:pig"] = {flying_pig = true},
    ["dmobs:pig_evil"] = {flying_pig = true, kamikaze_pig = true, evil_pig = true},
    ["dmobs:rat"] = {rat = true},
    ["dmobs:skeleton"] = {skeleton = true},
    ["dmobs:tortoise"] = {tortoise = true},
    ["dmobs:treeman"] = {treeman = true},
    ["dmobs:wasp"] = {wasp = true},
    ["dmobs:wasp_leader"] = {wasp = true, wasp_leader = true, king_of_sting = true},
    ["dmobs:waterdragon"] = {dragon = true, water_dragon = true, boss_water_dragon = true, waterdragon = true, boss_waterdragon = true},
    ["dmobs:waterdragon_2"] = {dragon = true, water_dragon = true, waterdragon = true},
    ["dmobs:whale"] = {whale = true},
    ["dmobs:wyvern"] = {wyvern = true},

    -- Draconis
    ["draconis:fire_dragon"] = {dragon = true, fire_dragon = true},
    ["draconis:ice_dragon"] = {dragon = true, ice_dragon = true},
    ["draconis:jungle_wyvern"] = {dragon = true, jungle_wyvern = true},

    -- Wilhelmines Living Nether
    ["livingnether:cyst"] = {cyst = true},
    ["livingnether:flyingrod"] = {flyingrod = true},
    ["livingnether:lavawalker"] = {lavawalker = true},
    ["livingnether:noodlemaster"] = {noodlemaster = true},
    ["livingnether:razorback"] = {razorback = true},
    ["livingnether:sokaarcher"] = {soka_archer = true, sokaarcher = true},
    ["livingnether:sokameele"] = {soka_meele = true, sokameele = true, soka_melee = true, sokamelee = true},
    ["livingnether:tardigrade"] = {tardigrade = true},
    ["livingnether:whip"] = {flesh_whip = true, whip = true},

    -- Mobs Redo mods:
    ["mobs_animal:bee"] = {bee = true},
    ["mobs_animal:cow"] = {cow = true},
    ["mobs_animal:bunny"] = {bunny = true},
    ["mobs_animal:chicken"] = {chicken = true},
    ["mobs_animal:kitten"] = {kitten = true},
    ["mobs_animal:panda"] = {panda = true},
    ["mobs_animal:penguin"] = {penguin = true},
    ["mobs_animal:pumba"] = {pumba = true, pumbaa = true, warthog = true}, -- they misspelled it...
    ["mobs_animal:rat"] = {rat = true},

    ["mobs_balrog:balrog"] = {balrog = true},

    ["mobs_crocs:crocodile"] = {crocodile = true},
    ["mobs_crocs:crocodile_float"] = {crocodile = true},
    ["mobs_crocs:crocodile_swim"] = {crocodile = true},

    ["mobs_fish:clownfish"] = {clownfish = true},
    ["mobs_fish:tropical"] = {tropical_fish = true},

    ["mob_horse:horse"] = {horse = true},

    ["mobs_jellyfish:jellyfish"] = {jellyfish = true},

    ["mob_mese_monster_classic:mese_monster"] = {mese_monster = true, classic_mese_monster = true},

    ["mobs_monster:dirt_monster"] = {dirt_monster = true},
    ["mobs_monster:dungeon_master"] = {dungeon_master = true},
    ["mobs_monster:fire_spirit"] = {fire_spirit = true},
    ["mobs_monster:land_guard"] = {land_guard = true},
    ["mobs_monster:lava_flan"] = {lava_flan = true},
    ["mobs_monster:mese_monster"] = {mese_monster = true},
    ["mobs_monster:obsidian_flan"] = {obsidian_flan = true},
    ["mobs_monster:oerkki"] = {oerkki = true},
    ["mobs_monster:sand_monster"] = {sand_monster = true},
    ["mobs_monster:spider"] = {spider = true},
    ["mobs_monster:stone_monster"] = {stone_monster = true},
    ["mobs_monster:tree_monster"] = {tree_monster = true},

    ["mobs_sharks:shark_lg"] = {shark = true},
    ["mobs_sharks:shark_md"] = {shark = true},
    ["mobs_sharks:shark_sm"] = {shark = true},

    ["mobs_skeletons:skeleton"] = {skeleton = true, wither_skeleton = true},
    ["mobs_skeletons:skeleton_archer"] = {skeleton_archer = true}, -- would have "skeleton" but overlaps
    ["mobs_skeletons:skeleton_archer_dark"] = {dark_skeleton_archer = true, stray = true},

    ["mobs_turtles:turtle"] = {turtle = true},
    ["mobs_turtles:seaturtle"] = {sea_turtle = true, seaturtle = true},

    -- MCLA/VL:
    ["mobs_mc:axolotl"] = {axolotl = true},
    ["mobs_mc:baby_hoglin"] = {hoglin = true, baby_hoglin = true},
    ["mobs_mc:baby_husk"] = {husk = true, baby_husk = true},
    ["mobs_mc:baby_strider"] = {strider = true, baby_strider = true},
    ["mobs_mc:baby_zombie"] = {zombie = true, baby_zombie = true},
    ["mobs_mc:bat"] = {bat = true},
    ["mobs_mc:blaze"] = {blaze = true},
    ["mobs_mc:cat"] = {cat = true},
    ["mobs_mc:cave_spider"] = {cave_spider = true},
    ["mobs_mc:chicken"] = {chicken = true},
    ["mobs_mc:cod"] = {cod = true},
    ["mobs_mc:cow"] = {cow = true},
    ["mobs_mc:creeper"] = {creeper = true},
    ["mobs_mc:creeper_charged"] = {creeper = true, charged_creeper = true},
    ["mobs_mc:dog"] = {wolf = true},
    ["mobs_mc:dolphin"] = {dolphin = true},
    ["mobs_mc:donkey"] = {donkey = true},
    ["mobs_mc:enderdragon"] = {ender_dragon = true},
    ["mobs_mc:enderman"] = {enderman = true},
    ["mobs_mc:endermite"] = {endermite = true},
    ["mobs_mc:evoker"] = {evoker = true},
    ["mobs_mc:ghast"] = {ghast = true},
    ["mobs_mc:glow_squid"] = {glow_squid = true},
    ["mobs_mc:guardian"] = {guardian = true},
    ["mobs_mc:guardian_elder"] = {elder_guardian = true},
    ["mobs_mc:hoglin"] = {hoglin = true},
    ["mobs_mc:horse"] = {horse = true},
    ["mobs_mc:husk"] = {husk = true},
    ["mobs_mc:illusioner"] = {illusioner = true},
    ["mobs_mc:iron_golem"] = {iron_golem = true},
    ["mobs_mc:killer_bunny"] = {rabbit = true, killer_bunny = true},
    ["mobs_mc:llama"] = {llama = true},
    ["mobs_mc:magma_cube_big"] = {magma_cube = true, big_magma_cube = true},
    ["mobs_mc:magma_cube_small"] = {magma_cube = true, small_magma_cube = true},
    ["mobs_mc:magma_cube_tiny"] = {magma_cube = true, tiny_magma_cube = true},
    ["mobs_mc:mooshroom"] = {mooshroom = true},
    ["mobs_mc:mule"] = {mule = true},
    ["mobs_mc:ocelot"] = {ocelot = true},
    ["mobs_mc:parrot"] = {parrot = true},
    ["mobs_mc:pig"] = {pig = true},
    ["mobs_mc:piglin"] = {piglin = true},
    ["mobs_mc:piglin_brute"] = {piglin_brute = true},
    ["mobs_mc:pillager"] = {pillager = true},
    ["mobs_mc:polar_bear"] = {polar_bear = true},
    ["mobs_mc:rabbit"] = {rabbit = true},
    ["mobs_mc:salmon"] = {salmon = true},
    ["mobs_mc:sheep"] = {sheep = true},
    ["mobs_mc:shulker"] = {shulker = true},
    ["mobs_mc:silverfish"] = {silverfish = true},
    ["mobs_mc:skeleton"] = {skeleton = true},
    ["mobs_mc:skeleton_horse"] = {skeleton_horse = true},
    ["mobs_mc:slime_big"] = {slime = true, big_slime = true},
    ["mobs_mc:slime_small"] = {slime = true, small_slime = true},
    ["mobs_mc:slime_tiny"] = {slime = true, tiny_slime = true},
    ["mobs_mc:snowman"] = {snow_golem = true, snowman = true},
    ["mobs_mc:spider"] = {spider = true},
    ["mobs_mc:squid"] = {squid = true},
    ["mobs_mc:stray"] = {stray = true},
    ["mobs_mc:strider"] = {strider = true},
    ["mobs_mc:sword_piglin"] = {zombie_piglin = true, zombified_piglin = true},
    ["mobs_mc:tropical_fish"] = {tropical_fish = true, clownfish = true},
    ["mobs_mc:vex"] = {vex = true},
    ["mobs_mc:villager"] = {villager = true},
    ["mobs_mc:villager_zombie"] = {zombie_villager = true},
    ["mobs_mc:vindicator"] = {vindicator = true},
    ["mobs_mc:witch"] = {witch = true},
    ["mobs_mc:wither"] = {wither = true},
    ["mobs_mc:witherskeleton"] = {wither_skeleton = true},
    ["mobs_mc:wolf"] = {wolf = true},
    ["mobs_mc:zoglin"] = {zoglin = true},
    ["mobs_mc:zombie"] = {zombie = true},
    ["mobs_mc:zombie_horse"] = {zombie_horse = true},
    ["mobs_mc:zombified_piglin"] = {zombie_piglin = true, zombified_piglin = true},

    ["nssm:ant_queen"] = {ant = true, ant_queen = true},
    ["nssm:ant_soldier"] = {ant = true, ant_soldier = true},
    ["nssm:ant_worker"] = {ant = true, ant_worker = true},
    ["nssm:black_widow"] = {spider = true, black_widow = true, black_widow_spider = true},
    ["nssm:bloco"] = {bloco = true},
    ["nssm:crab"] = {crab = true},
    ["nssm:crocodile"] = {crocodile = true},
    ["nssm:daddy_long_legs"] = {daddy_long_legs = true},
    ["nssm:dolidrosaurus"] = {dolidrosaurus = true},
    ["nssm:duck"] = {duck = true},
    ["nssm:duckking"] = {duck = true, duck_king = true, duckking = true},
    ["nssm:echidna"] = {echidna = true},
    ["nssm:enderduck"] = {duck = true, ender_duck = true, enderduck = true},
    ["nssm:felucco"] = {felucco = true},
    ["nssm:flying_duck"] = {duck = true, flying_duck = true},
    ["nssm:giant_sandworm"] = {sandworm = true, giant_sandworm = true},
    ["nssm:icelamander"] = {icelamander = true},
    ["nssm:icesnake"] = {ice_snake = true, icesnake = true},
    ["nssm:kraken"] = {kraken = true},
    ["nssm:larva"] = {larva = true},
    ["nssm:lava_titan"] = {lava_titan = true},
    ["nssm:manticore"] = {manticore = true},
    ["nssm:mantis"] = {mantis = true},
    ["nssm:mantis_beast"] = {mantis = true, mantis_beast = true},
    ["nssm:masticone"] = {masticone = true},
    ["nssm:mese_dragon"] = {dragon = true, mese_dragon = true},
    ["nssm:moonheron"] = {moonheron = true, moon_heron = true},
    ["nssm:morbat1"] = {morbat = true, morbat1 = true},
    ["nssm:morbat2"] = {morbat = true, morbat2 = true},
    ["nssm:morbat3"] = {morbat = true, morbat3 = true},
    ["nssm:mordain"] = {mordain = true},
    ["nssm:morde"] = {morde = true},
    ["nssm:morgre"] = {morgre = true},
    ["nssm:morgut"] = {morgut = true},
    ["nssm:morlu"] = {morlu = true},
    ["nssm:mortick"] = {mortick = true},
    ["nssm:morvalar"] = {morvalar = true, morvalar7 = true},
    ["nssm:morvalar6"] = {morvalar = true, morvalar6 = true},
    ["nssm:morvalar5"] = {morvalar = true, morvalar5 = true},
    ["nssm:morvalar4"] = {morvalar = true, morvalar4 = true},
    ["nssm:morvalar3"] = {morvalar = true, morvalar3 = true},
    ["nssm:morvalar2"] = {morvalar = true, morvalar2 = true},
    ["nssm:morvalar1"] = {morvalar = true, morvalar1 = true},
    ["nssm:morvalar0"] = {morvalar = true, morvalar0 = true},
    ["nssm:morvy"] = {morvy = true},
    ["nssm:morwa"] = {morwa = true},
    ["nssm:night_master"] = {night_master = true, night_master_3 = true},
    ["nssm:night_master_2"] = {night_master = true, night_master_2 = true},
    ["nssm:night_master_1"] = {night_master = true, night_master_1 = true},
    ["nssm:octopus"] = {octopus = true},
    ["nssm:phoenix"] = {phoenix = true},
    ["nssm:pumpboom_large"] = {pumpboom = true, large_pumpboom = true},
    ["nssm:pumpboom_medium"] = {pumpboom = true, medium_pumpboom = true},
    ["nssm:pumpboom_small"] = {pumpboom = true, small_pumpboom = true},
    ["nssm:pumpking"] = {pumpking = true},
    ["nssm:sand_bloco"] = {bloco = true, sand_bloco = true},
    ["nssm:sandworm"] = {sandworm = true},
    ["nssm:scrausics"] = {scrausics = true},
    ["nssm:signosigno"] = {signosigno = true},
    ["nssm:snow_biter"] = {snow_biter = true},
    ["nssm:spiderduck"] = {duck = true, spiderduck = true, spider_duck = true},
    ["nssm:stone_eater"] = {stone_eater = true, stoneater = true},
    ["nssm:swimming_duck"] = {duck = true, swimming_duck = true},
    ["nssm:tarantula"] = {tarantula = true, spitting_tarantula = true}, -- Had to call them something
    ["nssm:tarantula_propower"] = {tarantula = true, biting_tarantula = true},
    ["nssm:uloboros"] = {uloboros = true},
    ["nssm:werewolf"] = {werewolf = true},
    ["nssm:white_werewolf"] = {werewolf = true, white_werewolf = true},
    ["nssm:xgaloctopus"] = {xgaloctopus = true},
}

better_commands.unique_entities = {}

--[[ Basically makes this kind of table:
{
    slime = {"mobs_mc:slime_big", "mobs_mc:slime_small", "mobs_mc:slime_tiny"},
    wolf = {"mobs_mc:wolf"}
}
]]
minetest.register_on_mods_loaded(function()
    local exists
    for id, value in pairs(better_commands.entity_aliases) do
        if minetest.registered_entities[id] then
            for alias in pairs(value) do
                if not better_commands.unique_entities[alias] then
                    better_commands.unique_entities[alias] = {}
                end
                exists = false
                for _, existing_id in ipairs(better_commands.unique_entities[alias]) do
                    if id == existing_id then
                        exists = true
                    end
                end
                if not exists then
                    table.insert(better_commands.unique_entities[alias], id)
                end
            end
        end
    end
end)

better_commands.entity_names = {
    -- Built-in:
    -- ["__builtin:item"] = S("Item"), -- Handled separately
    -- ["__builtin:falling_node"] = S("Falling Node"), -- Handled separately

    -- Animalia
    ["animalia:angelfish"] = S("Angelfish"),
    ["animalia:bat"] = S("Bat"),
    ["animalia:bird"] = S("Bird"),
    ["animalia:blue_tang"] = S("Blue Tang"),
    ["animalia:cat"] = S("Cat"),
    ["animalia:chicken"] = S("Chicken"),
    ["animalia:clownfish"] = S("Clownfish"),
    ["animalia:cow"] = S("Cow"),
    ["animalia:fox"] = S("Fox"),
    ["animalia:frog"] = S("Frog"),
    ["animalia:grizzly_bear"] = S("Grizzly Bear"),
    ["animalia:horse"] = S("Horse"),
    ["animalia:opossum"] = S("Opossum"),
    ["animalia:owl"] = S("Owl"),
    ["animalia:pig"] = S("Pig"),
    ["animalia:rat"] = S("Rat"),
    ["animalia:reindeer"] = S("Reindeer"),
    ["animalia:sheep"] = S("Sheep"),
    ["animalia:song_bird"] = S("Song Bird"),
    ["animalia:tropical_fish"] = S("Tropical Fish"),
    ["animalia:turkey"] = S("Turkey"),
    ["animalia:wolf"] = S("Wolf"),

    ["dmobs:badger"] = S("Badger"),
    ["dmobs:butterfly"] = S("Butterfly"),
    ["dmobs:dragon1"] = S("Fire Dragon"),
    ["dmobs:dragon2"] = S("Lightning Dragon"),
    ["dmobs:dragon3"] = S("Poison Dragon"),
    ["dmobs:dragon4"] = S("Ice Dragon"),
    ["dmobs:dragon_black"] = S("Lightning Dragon"),
    ["dmobs:dragon_blue"] = S("Ice Dragon"),
    ["dmobs:dragon_great"] = S("Boss Dragon"),
    ["dmobs:dragon_great_tame"] = S("Boss Dragon"),
    ["dmobs:dragon_green"] = S("Poison Dragon"),
    ["dmobs:dragon_red"] = S("Fire Dragon"),
    ["dmobs:elephant"] = S("Elephant"),
    ["dmobs:fox"] = S("Fox"),
    ["dmobs:gnorm"] = S("Gnorm"),
    ["dmobs:golem"] = S("Golem"),
    ["dmobs:golem_friendly"] = S("Golem"),
    ["dmobs:hedgehog"] = S("Hedgehog"),
    ["dmobs:nyan"] = S("Nyan Cat"),
    ["dmobs:ogre"] = S("Ogre"),
    ["dmobs:orc"] = S("Orc"),
    ["dmobs:orc2"] = S("Morgul Orc"),
    ["dmobs:owl"] = S("Owl"),
    ["dmobs:panda"] = S("Panda"),
    ["dmobs:pig"] = S("Flying Pig"),
    ["dmobs:pig_evil"] = S("Flying Pig"),
    ["dmobs:rat"] = S("Rat"),
    ["dmobs:skeleton"] = S("Skeleton"),
    ["dmobs:tortoise"] = S("Tortoise"),
    ["dmobs:treeman"] = S("Treeman"),
    ["dmobs:wasp"] = S("Wasp"),
    ["dmobs:wasp_leader"] = S("King of Sting"),
    ["dmobs:waterdragon"] = S("Boss Waterdragon"),
    ["dmobs:waterdragon_2"] = S("Waterdragon"),
    ["dmobs:whale"] = S("Whale"),
    ["dmobs:wyvern"] = S("Wyvern"),

    -- Draconis
    ["draconis:fire_dragon"] = S("Fire Dragon"),
    ["draconis:ice_dragon"] = S("Ice Dragon"),
    ["draconis:jungle_wyvern"] = S("Jungle Wyvern"),

    -- Wilhelmines Living Nether
    ["livingnether:cyst"] = S("Cyst"),
    ["livingnether:flyingrod"] = S("Flyingrod"),
    ["livingnether:lavawalker"] = S("Lavawalker"),
    ["livingnether:noodlemaster"] = S("Noodlemaster"),
    ["livingnether:razorback"] = S("Razorback"),
    ["livingnether:sokaarcher"] = S("Soka Archer"),
    ["livingnether:sokameele"] = S("Soka Melee"),
    ["livingnether:tardigrade"] = S("Tardigrade"),
    ["livingnether:whip"] = S("Flesh Whip"),

    -- Mobs Redo:
    ["mobs_animal:bee"] = S("Bee"),
    ["mobs_animal:cow"] = S("Cow"),
    ["mobs_animal:bunny"] = S("Bunny"),
    ["mobs_animal:chicken"] = S("Chicken"),
    ["mobs_animal:kitten"] = S("Kitten"),
    ["mobs_animal:panda"] = S("Panda"),
    ["mobs_animal:penguin"] = S("Penguin"),
    ["mobs_animal:pumba"] = S("Pumba"),
    ["mobs_animal:rat"] = S("Rat"),

    ["mobs_balrog:balrog"] = S("Balrog"),

    ["mobs_crocs:crocodile"] = S("Crocodile"),
    ["mobs_crocs:crocodile_float"] = S("Crocodile"),
    ["mobs_crocs:crocodile_swim"] = S("Crocodile"),

    ["mobs_fish:clownfish"] = S("Clownfish"),
    ["mobs_fish:tropical"] = S("Tropical Fish"),

    ["mob_horse:horse"] = S("Horse"),

    ["mobs_jellyfish:jellyfish"] = S("Jellyfish"),

    ["mob_mese_monster_classic:mese_monster"] = S("Mese Monster"),

    ["mobs_monster:dirt_monster"] = S("Dirt Monster"),
    ["mobs_monster:dungeon_master"] = S("Dungeon Master"),
    ["mobs_monster:fire_spirit"] = S("Fire Spirit"),
    ["mobs_monster:land_guard"] = S("Land Guard"),
    ["mobs_monster:lava_flan"] = S("Lava Flan"),
    ["mobs_monster:mese_monster"] = S("Mese Monster"),
    ["mobs_monster:obsidian_flan"] = S("Obsidian Flan"),
    ["mobs_monster:oerkki"] = S("Oerkki"),
    ["mobs_monster:sand_monster"] = S("Sand Monster"),
    ["mobs_monster:spider"] = S("Spider"),
    ["mobs_monster:stone_monster"] = S("Stone Monster"),
    ["mobs_monster:tree_monster"] = S("Tree Monster"),

    ["mobs_sharks:shark_lg"] = S("Shark"),
    ["mobs_sharks:shark_md"] = S("Shark"),
    ["mobs_sharks:shark_sm"] = S("Shark"),

    ["mobs_skeletons:skeleton"] = S("Skeleton"),
    ["mobs_skeletons:skeleton_archer"] = S("Skeleton Archer"),
    ["mobs_skeletons:skeleton_archer_dark"] = S("Dark Skeleton Archer"),

    ["mobs_turtles:turtle"] = S("Turtle"),
    ["mobs_turtles:seaturtle"] = S("Sea Turtle"),

    -- MCLA/VL mobs all use luaentity.description
    ["nssm:ant_queen"] = S("Ant Queen"),
    ["nssm:ant_soldier"] = S("Ant Soldier"),
    ["nssm:ant_worker"] = S("Ant Worker"),
    ["nssm:black_widow"] = S("Black Widow"),
    ["nssm:bloco"] = S("Bloco"),
    ["nssm:crab"] = S("Crab"),
    ["nssm:crocodile"] = S("Crocodile"),
    ["nssm:daddy_long_legs"] = S("Daddy Long Legs"),
    ["nssm:dolidrosaurus"] = S("Dolidrosaurus"),
    ["nssm:duck"] = S("Duck"),
    ["nssm:duckking"] = S("Duckking"),
    ["nssm:echidna"] = S("Echidna"),
    ["nssm:enderduck"] = S("Enderduck"),
    ["nssm:felucco"] = S("Felucco"),
    ["nssm:flying_duck"] = S("Flying Duck"),
    ["nssm:giant_sandworm"] = S("Giant Sandworm"),
    ["nssm:icelamander"] = S("Icelamander"),
    ["nssm:icesnake"] = S("Icesnake"),
    ["nssm:kraken"] = S("Kraken"),
    ["nssm:larva"] = S("Larva"),
    ["nssm:lava_titan"] = S("Lava Titan"),
    ["nssm:manticore"] = S("Manticore"),
    ["nssm:mantis"] = S("Mantis"),
    ["nssm:mantis_beast"] = S("Mantis Beast"),
    ["nssm:masticone"] = S("Masticone"),
    ["nssm:mese_dragon"] = S("Mese Dragon"),
    ["nssm:moonheron"] = S("Moonheron"),
    ["nssm:morbat1"] = S("Morbat"),
    ["nssm:morbat2"] = S("Morbat"),
    ["nssm:morbat3"] = S("Morbat"),
    ["nssm:mordain"] = S("Mordain"),
    ["nssm:morde"] = S("Morde"),
    ["nssm:morgre"] = S("Morgre"),
    ["nssm:morgut"] = S("Morgut"),
    ["nssm:morlu"] = S("Morlu"),
    ["nssm:mortick"] = S("Mortick"),
    ["nssm:morvalar"] = S("Morvalar"),
    ["nssm:morvalar6"] = S("Morvalar"),
    ["nssm:morvalar5"] = S("Morvalar"),
    ["nssm:morvalar4"] = S("Morvalar"),
    ["nssm:morvalar3"] = S("Morvalar"),
    ["nssm:morvalar2"] = S("Morvalar"),
    ["nssm:morvalar1"] = S("Morvalar"),
    ["nssm:morvalar0"] = S("Morvalar"),
    ["nssm:morvy"] = S("Morvy"),
    ["nssm:morwa"] = S("Morwa"),
    ["nssm:night_master"] = S("Night Master"),
    ["nssm:night_master_2"] = S("Night Master"),
    ["nssm:night_master_1"] = S("Night Master"),
    ["nssm:octopus"] = S("Octopus"),
    ["nssm:phoenix"] = S("Phoenix"),
    ["nssm:pumpboom_large"] = S("Pumpboom"),
    ["nssm:pumpboom_medium"] = S("Pumpboom"),
    ["nssm:pumpboom_small"] = S("Pumpboom"),
    ["nssm:pumpking"] = S("Pumpking"),
    ["nssm:sand_bloco"] = S("Sand Bloco"),
    ["nssm:sandworm"] = S("Sandworm"),
    ["nssm:scrausics"] = S("Scrausics"),
    ["nssm:signosigno"] = S("Signosigno"),
    ["nssm:snow_biter"] = S("Snow Biter"),
    ["nssm:spiderduck"] = S("Spiderduck"),
    ["nssm:stone_eater"] = S("Stoneater"),
    ["nssm:swimming_duck"] = S("Swimming Duck"),
    ["nssm:tarantula"] = S("Tarantula"),
    ["nssm:tarantula_propower"] = S("Tarantula"),
    ["nssm:uloboros"] = S("Uloboros"),
    ["nssm:werewolf"] = S("Werewolf"),
    ["nssm:white_werewolf"] = S("Werewolf"),
    ["nssm:xgaloctopus"] = S("Xgaloctobus"),
}

local sheep_colors = {
    white = "White",
    black = "Black",
    blue = "Blue",
    cyan = "Cyan",
    grey = "Grey",
    magenta = "Magenta",
    orange = "Orange",
    pink = "Pink",
    red = "Red",
    violet = "Violet",
    yellow = "Yellow",
    dark_green = "Dark Green",
    green = "Green",
    dark_grey = "Dark Grey",
    brown = "Brown"
}

for color, title in pairs(sheep_colors) do
    better_commands.entity_aliases["mobs_animal:sheep_"..color] = {[color.."_sheep"] = true, sheep = true}
    better_commands.entity_names["mobs_animal:sheep_"..color] = S("@1 Sheep", S(title))
end