--[[
This mod uses Java Edition itemstrings.

Also, after doing all this, I realized that MineClone already does a similar thing...
]]

local prefix = minetest.settings:get("too_many_aliases_prefix")
if prefix == nil then prefix = "mineclone:" end

local aliases = {
    ["doc_identifier:identifier_solid"] = "lookup_tool",

    ["mcl_anvils:anvil_damage_1"] = "chipped_anvil",
    ["mcl_anvils:anvil_damage_2"] = "damaged_anvil",

    ["mcl_armor:boots_chain"] = "chainmail_boots",
    ["mcl_armor:boots_diamond"] = "diamond_boots",
    ["mcl_armor:boots_gold"] = "golden_boots",
    ["mcl_armor:boots_iron"] = "iron_boots",
    ["mcl_armor:boots_leather"] = "leather_boots",
    ["mcl_armor:boots_netherite"] = "netherite_boots",
    ["mcl_armor:chestplate_chain"] = "chainmail_chestplate",
    ["mcl_armor:chestplate_diamond"] = "diamond_chestplate",
    ["mcl_armor:chestplate_gold"] = "golden_chestplate",
    ["mcl_armor:chestplate_iron"] = "iron_chestplate",
    ["mcl_armor:chestplate_leather"] = "leather_chestplate",
    ["mcl_armor:chestplate_netherite"] = "netherite_chestplate",
    ["mcl_armor:leggings_chain"] = "chainmail_leggings",
    ["mcl_armor:leggings_diamond"] = "diamond_leggings",
    ["mcl_armor:leggings_gold"] = "golden_leggings",
    ["mcl_armor:leggings_iron"] = "iron_leggings",
    ["mcl_armor:leggings_leather"] = "leather_leggings",
    ["mcl_armor:leggings_netherite"] = "netherite_leggings",
    ["mcl_armor:helmet_chain"] = "chainmail_helmet",
    ["mcl_armor:helmet_diamond"] = "diamond_helmet",
    ["mcl_armor:helmet_gold"] = "golden_helmet",
    ["mcl_armor:helmet_iron"] = "iron_helmet",
    ["mcl_armor:helmet_leather"] = "leather_helmet",
    ["mcl_armor:helmet_netherite"] = "netherite_helmet",

    ["mcl_bamboo:bamboo_block_stripped"] = "stripped_bamboo_block",
    ["mcl_bamboo:bamboo_plank"] = "bamboo_planks",
    ["mcl_bamboo:pressure_plate_bamboo_wood_off"] = "bamboo_pressure_plate",

    ["mcl_banners:banner_item_black"] = "black_banner",
    ["mcl_banners:banner_item_blue"] = "blue_banner",
    ["mcl_banners:banner_item_brown"] = "brown_banner",
    ["mcl_banners:banner_item_cyan"] = "cyan_banner",
    ["mcl_banners:banner_item_green"] = "green_banner",
    ["mcl_banners:banner_item_grey"] = "gray_banner",
    ["mcl_banners:banner_item_light_blue"] = "light_blue_banner",
    ["mcl_banners:banner_item_lime"] = "lime_banner",
    ["mcl_banners:banner_item_magenta"] = "magenta_banner",
    ["mcl_banners:banner_item_orange"] = "orange_banner",
    ["mcl_banners:banner_item_pink"] = "pink_banner",
    ["mcl_banners:banner_item_purple"] = "purple_banner",
    ["mcl_banners:banner_item_red"] = "red_banner",
    ["mcl_banners:banner_item_silver"] = "light_gray_banner",
    ["mcl_banners:banner_item_white"] = "white_banner",
    ["mcl_banners:banner_item_yellow"] = "yellow_banner",

    ["mcl_beds:bed_black_bottom"] = "black_bed",
    ["mcl_beds:bed_blue_bottom"] = "blue_bed",
    ["mcl_beds:bed_brown_bottom"] = "brown_bed",
    ["mcl_beds:bed_cyan_bottom"] = "cyan_bed",
    ["mcl_beds:bed_green_bottom"] = "green_bed",
    ["mcl_beds:bed_grey_bottom"] = "gray_bed",
    ["mcl_beds:bed_light_blue_bottom"] = "light_blue_bed",
    ["mcl_beds:bed_lime_bottom"] = "lime_bed",
    ["mcl_beds:bed_magenta_bottom"] = "magenta_bed",
    ["mcl_beds:bed_orange_bottom"] = "orange_bed",
    ["mcl_beds:bed_pink_bottom"] = "pink_bed",
    ["mcl_beds:bed_purple_bottom"] = "purple_bed",
    ["mcl_beds:bed_red_bottom"] = "red_bed",
    ["mcl_beds:bed_silver_bottom"] = "light_gray_bed",
    ["mcl_beds:bed_white_bottom"] = "white_bed",
    ["mcl_beds:bed_yellow_bottom"] = "yellow_bed",

    ["mcl_blackstone:basalt_polished"] = "polished_basalt",
    ["mcl_blackstone:basalt_smooth"] = "smooth_basalt",
    ["mcl_blackstone:blackstone_brick_polished"] = "polished_blackstone_bricks",
    ["mcl_blackstone:blackstone_chiseled_polished"] = "chiseled_polished_blackstone",
    ["mcl_blackstone:blackstone_gilded"] = "gilded_blackstone",
    ["mcl_blackstone:blackstone_polished"] = "polished_blackstone",
    ["mcl_blackstone:nether_gold"] = "nether_gold_ore",
    ["mcl_blackstone:quartz_brick"] = "quartz_bricks",
    ["mcl_blackstone:wall"] = "blackstone_wall",
    ["mcl_blackstone:soul_fire"] = "soul_fire", 

    ["mcl_boats:boat"] = "oak_boat",
    ["mcl_boats:boat_acacia"] = "acacia_boat",
    ["mcl_boats:boat_birch"] = "birch_boat",
    ["mcl_boats:boat_cherry"] = "cherry_boat",
    ["mcl_boats:boat_dark_oak"] = "dark_oak_boat",
    ["mcl_boats:boat_jungle"] = "jungle_boat",
    ["mcl_boats:boat_mangrove"] = "mangrove_boat",
    ["mcl_boats:boat_obsidian"] = "obsidian_boat",
    ["mcl_boats:boat_spruce"] = "spruce_boat",
    ["mcl_boats:chest_boat"] = "oak_chest_boat",
    ["mcl_boats:chest_boat_acacia"] = "acacia_chest_boat",
    ["mcl_boats:chest_boat_birch"] = "birch_chest_boat",
    ["mcl_boats:chest_boat_cherry"] = "cherry_chest_boat",
    ["mcl_boats:chest_boat_dark_oak"] = "dark_oak_chest_boat",
    ["mcl_boats:chest_boat_jungle"] = "jungle_chest_boat",
    ["mcl_boats:chest_boat_mangrove"] = "mangrove_chest_boat",
    ["mcl_boats:chest_boat_spruce"] = "spruce_chest_boat",

    ["mcl_brewing:stand_000"] = "brewing_stand",

    ["mcl_buckets:bucket_axolotl"] = "axolotl_bucket",
    ["mcl_buckets:bucket_cod"] = "cod_bucket",
    ["mcl_buckets:bucket_empty"] = "bucket",
    ["mcl_buckets:bucket_lava"] = "lava_bucket",
    ["mcl_buckets:bucket_river_water"] = "river_water_bucket",
    ["mcl_buckets:bucket_salmon"] = "salmon_bucket",
    ["mcl_buckets:bucket_tropical_fish"] = "tropical_fish_bucket",
    ["mcl_buckets:bucket_water"] = "water_bucket",

    ["mcl_campfires:campfire_lit"] = "campfire",
    ["mcl_campfires:campfire"] = "campfire_unlit", --In MineCraft, 'lit' = block state
    ["mcl_campfires:soul_campfire_lit"] = "campfire",
    ["mcl_campfires:soul_campfire"] = "campfire_unlit", --In MineCraft, 'lit' = block state

    ["mcl_cherry_blossom:cherryleaves"] = "cherry_leaves",
    ["mcl_cherry_blossom:cherrysapling"] = "cherry_sapling",
    ["mcl_cherry_blossom:cherrytree"] = "cherry_log",
    ["mcl_cherry_blossom:cherrytree_bark"] = "cherry_wood",
    ["mcl_cherry_blossom:stripped_cherrytree"] = "stripped_cherry_log",
    ["mcl_cherry_blossom:stripped_cherrytree_bark"] = "stripped_cherry_wood",
    ["mcl_cherry_blossom:cherrywood"] = "cherry_planks",

    ["mcl_chests:violet_shulker_box"] = "shulker_box",
    ["mcl_chests:lime_shulker_box"] = "lime_shulker_box",
    ["mcl_chests:dark_green_shulker_box"] = "green_shulker_box", --Why dark green???
    ["mcl_chests:grey_shulker_box"] = "light_gray_shulker_box", --Wow; MineClone's inconsistent.
    ["mcl_chests:dark_grey_shulker_box"] = "gray_shulker_box",

    ["mcl_clocks:clock"] = "clock", --Just in case it doesn't work; maybe unnecessary

    ["mcl_colorblocks:concrete_black"] = "black_concrete",
    ["mcl_colorblocks:concrete_blue"] = "blue_concrete",
    ["mcl_colorblocks:concrete_brown"] = "brown_concrete",
    ["mcl_colorblocks:concrete_cyan"] = "cyan_concrete",
    ["mcl_colorblocks:concrete_green"] = "green_concrete",
    ["mcl_colorblocks:concrete_grey"] = "gray_concrete",
    ["mcl_colorblocks:concrete_light_blue"] = "light_blue_concrete",
    ["mcl_colorblocks:concrete_lime"] = "lime_concrete",
    ["mcl_colorblocks:concrete_magenta"] = "magenta_concrete",
    ["mcl_colorblocks:concrete_orange"] = "orange_concrete",
    ["mcl_colorblocks:concrete_pink"] = "pink_concrete",
    ["mcl_colorblocks:concrete_purple"] = "purple_concrete",
    ["mcl_colorblocks:concrete_red"] = "red_concrete",
    ["mcl_colorblocks:concrete_silver"] = "light_gray_concrete",
    ["mcl_colorblocks:concrete_white"] = "white_concrete",
    ["mcl_colorblocks:concrete_yellow"] = "yellow_concrete",
    ["mcl_colorblocks:concrete_powder_black"] = "black_concrete_powder",
    ["mcl_colorblocks:concrete_powder_blue"] = "blue_concrete_powder",
    ["mcl_colorblocks:concrete_powder_brown"] = "brown_concrete_powder",
    ["mcl_colorblocks:concrete_powder_cyan"] = "cyan_concrete_powder",
    ["mcl_colorblocks:concrete_powder_green"] = "green_concrete_powder",
    ["mcl_colorblocks:concrete_powder_grey"] = "gray_concrete_powder",
    ["mcl_colorblocks:concrete_powder_light_blue"] = "light_blue_concrete_powder",
    ["mcl_colorblocks:concrete_powder_lime"] = "lime_concrete_powder",
    ["mcl_colorblocks:concrete_powder_magenta"] = "magenta_concrete_powder",
    ["mcl_colorblocks:concrete_powder_orange"] = "orange_concrete_powder",
    ["mcl_colorblocks:concrete_powder_pink"] = "pink_concrete_powder",
    ["mcl_colorblocks:concrete_powder_purple"] = "purple_concrete_powder",
    ["mcl_colorblocks:concrete_powder_red"] = "red_concrete_powder",
    ["mcl_colorblocks:concrete_powder_silver"] = "light_gray_concrete_powder",
    ["mcl_colorblocks:concrete_powder_white"] = "white_concrete_powder",
    ["mcl_colorblocks:concrete_powder_yellow"] = "yellow_concrete_powder",
    ["mcl_colorblocks:glazed_terracotta_black"] = "black_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_blue"] = "blue_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_brown"] = "brown_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_cyan"] = "cyan_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_green"] = "green_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_grey"] = "gray_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_light_blue"] = "light_blue_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_lime"] = "lime_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_magenta"] = "magenta_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_orange"] = "orange_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_pink"] = "pink_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_purple"] = "purple_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_red"] = "red_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_silver"] = "light_gray_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_white"] = "white_glazed_terracotta",
    ["mcl_colorblocks:glazed_terracotta_yellow"] = "yellow_glazed_terracotta",
    ["mcl_colorblocks:hardened_clay_black"] = "black_terracotta",
    ["mcl_colorblocks:hardened_clay_blue"] = "blue_terracotta",
    ["mcl_colorblocks:hardened_clay_brown"] = "brown_terracotta",
    ["mcl_colorblocks:hardened_clay_cyan"] = "cyan_terracotta",
    ["mcl_colorblocks:hardened_clay_green"] = "green_terracotta",
    ["mcl_colorblocks:hardened_clay_grey"] = "gray_terracotta",
    ["mcl_colorblocks:hardened_clay_light_blue"] = "light_blue_terracotta",
    ["mcl_colorblocks:hardened_clay_lime"] = "lime_terracotta",
    ["mcl_colorblocks:hardened_clay_magenta"] = "magenta_terracotta",
    ["mcl_colorblocks:hardened_clay_orange"] = "orange_terracotta",
    ["mcl_colorblocks:hardened_clay_pink"] = "pink_terracotta",
    ["mcl_colorblocks:hardened_clay_purple"] = "purple_terracotta",
    ["mcl_colorblocks:hardened_clay_red"] = "red_terracotta",
    ["mcl_colorblocks:hardened_clay_silver"] = "light_gray_terracotta",
    ["mcl_colorblocks:hardened_clay_white"] = "white_terracotta",
    ["mcl_colorblocks:hardened_clay_yellow"] = "yellow_terracotta",

    ["mcl_comparators:comparator_off_comp"] = "comparator",

    ["mcl_compass:18"] = "compass",
    ["mcl_compass:18_recovery"] = "recovery_compass", --ID isn't in MineCraft wiki, weirdly.

    ["mcl_copper:block"] = "copper_block", --Whoever added copper... why??
    ["mcl_copper:block_cut"] = "cut_copper",
    ["mcl_copper:block_exposed"] = "exposed_copper",
    ["mcl_copper:block_exposed_cut"] = "exposed_cut_copper",
    ["mcl_copper:block_oxidized"] = "oxidized_copper",
    ["mcl_copper:block_oxidized_cut"] = "oxidized_cut_copper",
    ["mcl_copper:block_weathered"] = "weathered_copper",
    ["mcl_copper:block_weathered_cut"] = "weathered_cut_copper",
    ["mcl_copper:waxed_block"] = "waxed_copper_block",
    ["mcl_copper:waxed_block_cut"] = "waxed_cut_copper",
    ["mcl_copper:waxed_block_exposed"] = "waxed_exposed_copper",
    ["mcl_copper:waxed_block_exposed_cut"] = "waxed_exposed_cut_copper",
    ["mcl_copper:waxed_block_oxidized"] = "waxed_oxidized_copper",
    ["mcl_copper:waxed_block_oxidized_cut"] = "waxed_oxidized_cut_copper",
    ["mcl_copper:waxed_block_weathered"] = "waxed_weathered_copper",
    ["mcl_copper:waxed_block_weathered_cut"] = "waxed_weathered_cut_copper",
    ["mcl_copper:stone_with_copper"] = "copper_ore",

    ["mcl_core:acacialeaves"] = "acacia_leaves", -- *sigh* MTG, why no underscores?
    ["mcl_core:acaciasapling"] = "acacia_sapling",  -- (I assume it was MTG that started it)
    ["mcl_core:acaciatree"] = "acacia_log",
    ["mcl_core:acaciatree_bark"] = "acacia_wood",
    ["mcl_core:acaciawood"] = "acacia_planks",
    ["mcl_core:birchleaves"] = "birch_leaves",
    ["mcl_core:birchsapling"] = "birch_sapling",
    ["mcl_core:birchtree"] = "birch_log",
    ["mcl_core:birchtree_bark"] = "birch_wood",
    ["mcl_core:birchwood"] = "birch_planks",
    ["mcl_core:darkleaves"] = "dark_oak_leaves",
    ["mcl_core:darksapling"] = "dark_oak_sapling",
    ["mcl_core:darktree"] = "dark_oak_log",
    ["mcl_core:darktree_bark"] = "dark_oak_wood",
    ["mcl_core:darkwood"] = "dark_oak_planks",
    ["mcl_core:jungleleaves"] = "jungle_leaves",
    ["mcl_core:junglesapling"] = "jungle_sapling",
    ["mcl_core:jungletree"] = "jungle_log",
    ["mcl_core:jungletree_bark"] = "jungle_wood",
    ["mcl_core:junglewood"] = "jungle_planks",
    ["mcl_core:leaves"] = "oak_leaves",
    ["mcl_core:sapling"] = "oak_sapling",
    ["mcl_core:tree"] = "oak_log",
    ["mcl_core:tree_bark"] = "oak_wood",
    ["mcl_core:wood"] = "oak_planks",
    ["mcl_core:spruceleaves"] = "spruce_leaves",
    ["mcl_core:sprucesapling"] = "spruce_sapling",
    ["mcl_core:sprucetree"] = "spruce_log",
    ["mcl_core:sprucetree_bark"] = "spruce_wood",
    ["mcl_core:sprucewood"] = "spruce_planks",
    ["mcl_core:andesite_smooth"] = "polished_andesite",
    ["mcl_core:apple_gold"] = "golden_apple",
    ["mcl_core:apple_gold_enchanted"] = "enchanted_golden_apple",
    ["mcl_core:brick_block"] = "bricks",
    ["mcl_core:charcoal_lump"] = "charcoal",
    ["mcl_core:clay_lump"] = "clay_ball",
    ["mcl_core:coal_lump"] = "coal",
    ["mcl_core:coalblock"] = "coal_block",
    ["mcl_core:cobble"] = "cobblestone",
    ["mcl_core:deadbush"] = "dead_bush",
    ["mcl_core:diamondblock"] = "diamond_block",
    ["mcl_core:diorite_smooth"] = "polished_diorite",
    ["mcl_core:dirt_with_grass"] = "grass_block",
    ["mcl_core:emeraldblock"] = "emerald_block",
    ["mcl_core:glass_black"] = "black_stained_glass",
    ["mcl_core:glass_blue"] = "blue_stained_glass",
    ["mcl_core:glass_brown"] = "brown_stained_glass",
    ["mcl_core:glass_cyan"] = "cyan_stained_glass",
    ["mcl_core:glass_green"] = "green_stained_glass",
    ["mcl_core:glass_gray"] = "gray_stained_glass", --why is it grAy here instead of grEy like everything else???
    ["mcl_core:glass_light_blue"] = "light_blue_stained_glass",
    ["mcl_core:glass_lime"] = "lime_stained_glass",
    ["mcl_core:glass_magenta"] = "magenta_stained_glass",
    ["mcl_core:glass_orange"] = "orange_stained_glass",
    ["mcl_core:glass_pink"] = "pink_stained_glass",
    ["mcl_core:glass_purple"] = "purple_stained_glass",
    ["mcl_core:glass_red"] = "red_stained_glass",
    ["mcl_core:glass_silver"] = "light_gray_stained_glass",
    ["mcl_core:glass_white"] = "white_stained_glass",
    ["mcl_core:glass_yellow"] = "yellow_stained_glass",
    ["mcl_core:goldblock"] = "gold_block",
    ["mcl_core:granite_smooth"] = "polished_granite",
    ["mcl_core:grass_path"] = "dirt_path",
    ["mcl_core:ironblock"] = "iron_block",
    ["mcl_core:lapis"] = "lapis_lazuli",
    ["mcl_core:lapisblock"] = "lapis_block",
    ["mcl_core:light_14"] = "light", --not entirely necessary
    ["mcl_core:mossycobble"] = "mossy_cobblestone",
    ["mcl_core:redsand"] = "red_sand",
    ["mcl_core:redsandstone"] = "red_sandstone",
    ["mcl_core:redsandstonecarved"] = "chiseled_red_sandstone", --UNDERSCORES PLEASE.
    ["mcl_core:redsandstonesmooth"] = "cut_red_sandstone",
    ["mcl_core:redsandstonesmooth2"] = "smooth_red_sandstone", --Really? 2?
    ["mcl_core:reeds"] = "sugar_cane",
    ["mcl_core:sand"] = "sand",
    ["mcl_core:sandstone"] = "sandstone",
    ["mcl_core:sandstonecarved"] = "chiseled_sandstone",
    ["mcl_core:sandstonesmooth"] = "cut_sandstone",
    ["mcl_core:sandstonesmooth2"] = "smooth_sandstone",
    ["mcl_core:slimeblock"] = "slime_block",
    ["mcl_core:snowblock"] = "snow_block", --half of these are just adding underscores
    ["mcl_core:stone_smooth"] = "smooth_stone",
    ["mcl_core:stone_with_coal"] = "coal_ore",
    ["mcl_core:stone_with_diamond"] = "diamond_ore",
    ["mcl_core:stone_with_emerald"] = "emerald_ore",
    ["mcl_core:stone_with_gold"] = "gold_ore",
    ["mcl_core:stone_with_iron"] = "iron_ore",
    ["mcl_core:stone_with_lapis"] = "lapis_ore",
    ["mcl_core:stone_with_redstone"] = "redstone_ore",
    ["mcl_core:stonebrick"] = "stone_bricks",
    ["mcl_core:stonebrickcarved"] = "chiseled_stone_bricks",
    ["mcl_core:stonebrickcracked"] = "cracked_stone_bricks",
    ["mcl_core:stonebrickmossy"] = "mossy_stone_bricks",
    ["mcl_core:stripped_acacia"] = "stripped_acacia_log",
    ["mcl_core:stripped_birch"] = "stripped_birch_log",
    ["mcl_core:stripped_dark_oak"] = "stripped_dark_oak_log",
    ["mcl_core:stripped_jungle"] = "stripped_jungle_log",
    ["mcl_core:stripped_oak"] = "stripped_oak_log",
    ["mcl_core:stripped_spruce"] = "stripped_spruce_log",
    ["mcl_core:stripped_acacia_bark"] = "stripped_acacia_wood",
    ["mcl_core:stripped_birch_bark"] = "stripped_birch_wood",
    ["mcl_core:stripped_dark_oak_bark"] = "stripped_dark_oak_wood",
    ["mcl_core:stripped_jungle_bark"] = "stripped_jungle_wood",
    ["mcl_core:stripped_oak_bark"] = "stripped_oak_wood",
    ["mcl_core:stripped_spruce_bark"] = "stripped_spruce_wood",

    ["mcl_crimson:crimson_hyphae"] = "crimson_stem",
    ["mcl_crimson:crimson_hyphae_bark"] = "crimson_hyphae",
    ["mcl_crimson:crimson_hyphae_wood"] = "crimson_planks",
    ["mcl_crimson:stripped_crimson_hyphae"] = "stripped_crimson_stem",
    ["mcl_crimson:stripped_crimson_hyphae_bark"] = "stripped_crimson_hyphae",
    ["mcl_crimson:warped_hyphae"] = "warped_stem",
    ["mcl_crimson:warped_hyphae_bark"] = "warped_hyphae",
    ["mcl_crimson:warped_hyphae_wood"] = "warped_planks",
    ["mcl_crimson:stripped_warped_hyphae"] = "stripped_warped_stem",
    ["mcl_crimson:stripped_warped_hyphae_bark"] = "stripped_warped_hyphae",

    ["mcl_deepslate:deepslate_bricks_cracked"] = "cracked_deepslate_bricks",
    ["mcl_deepslate:deepslate_chiseled"] = "chiseled_deepslate",
    ["mcl_deepslate:deepslate_cobbled"] = "cobbled_deepslate",
    ["mcl_deepslate:deepslate_polished"] = "polished_deepslate",
    ["mcl_deepslate:deepslate_tiles_cracked"] = "cracked_deepslate_tiles",
    ["mcl_deepslate:deepslate_with_coal"] = "deepslate_coal_ore",
    ["mcl_deepslate:deepslate_with_copper"] = "deepslate_copper_ore",
    ["mcl_deepslate:deepslate_with_diamond"] = "deepslate_diamond_ore",
    ["mcl_deepslate:deepslate_with_emerald"] = "deepslate_emerald_ore",
    ["mcl_deepslate:deepslate_with_gold"] = "deepslate_gold_ore",
    ["mcl_deepslate:deepslate_with_iron"] = "deepslate_iron_ore",
    ["mcl_deepslate:deepslate_with_lapis"] = "deepslate_lapis_ore",
    ["mcl_deepslate:deepslate_with_reddeepslate"] = "deepslate_redstone_ore",
    ["mcl_deepslate:deepslatebrickswall"] = "deepslate_brick_wall",
    ["mcl_deepslate:deepslatecobbledwall"] = "cobbled_deepslate_wall",
    ["mcl_deepslate:deepslatepolishedwall"] = "polished_deepslate_wall",
    ["mcl_deepslate:deepslatetileswall"] = "polished_deepslate_wall",

    ["mcl_doors:wooden_door"] = "oak_door",
    ["mcl_doors:trapdoor"] = "oak_trapdoor",

    ["mcl_dye:black"] = "black_dye",
    ["mcl_dye:blue"] = "blue_dye",
    ["mcl_dye:brown"] = "brown_dye",
    ["mcl_dye:cyan"] = "cyan_dye",
    ["mcl_dye:dark_green"] = "green_dye", --Whyyyyy??
    ["mcl_dye:grey"] = "gray_dye",
    ["mcl_dye:light_blue"] = "light_blue_dye",
    ["mcl_dye:green"] = "lime_dye",
    ["mcl_dye:magenta"] = "magenta_dye",
    ["mcl_dye:orange"] = "orange_dye",
    ["mcl_dye:pink"] = "pink_dye",
    ["mcl_dye:purple"] = "purple_dye",
    ["mcl_dye:red"] = "red_dye",
    ["mcl_dye:silver"] = "light_gray_dye",
    ["mcl_dye:white"] = "white_dye",
    ["mcl_dye:yellow"] = "yellow_dye",

    ["mcl_enchanting:book_enchanted"] = "enchanted_book",
    ["mcl_enchanting:table"] = "enchanting_table",

    ["mcl_end:chorus_fruit_popped"] = "popped_chorus_fruit",
    ["mcl_end:crystal"] = "end_crystal",
    ["mcl_end:end_bricks"] = "end_stone_bricks",

    ["mcl_experience:bottle"] = "experience_bottle",

    ["mcl_farming:beetroot_item"] = "beetroot",
    ["mcl_farming:carrot_item"] = "carrot",
    ["mcl_farming:carrot_item_gold"] = "golden_carrot",
    ["mcl_farming:hoe_diamond"] = "diamond_hoe",
    ["mcl_farming:hoe_gold"] = "golden_hoe",
    ["mcl_farming:hoe_iron"] = "iron_hoe",
    ["mcl_farming:hoe_netherite"] = "netherite_hoe",
    ["mcl_farming:hoe_stone"] = "stone_hoe",
    ["mcl_farming:hoe_wood"] = "wooden_hoe",
    ["mcl_farming:melon_item"] = "melon_slice",
    ["mcl_farming:potato_item"] = "potato",
    ["mcl_farming:potato_item_baked"] = "baked_potato",
    ["mcl_farming:potato_item_poison"] = "poisonous_potato",
    ["mcl_farming:pumpkin_face"] = "carved_pumpkin",
    ["mcl_farming:pumpkin_face_light"] = "jack_o_lantern",
    ["mcl_farming:soil"] = "farmland",
    ["mcl_farming:sweet_berry"] = "sweet_berries",
    ["mcl_farming:wheat_item"] = "wheat",

    ["mcl_fire:fire"] = "fire",

    ["mcl_fireworks:rocket_1"] = "firework_rocket_1",
    ["mcl_fireworks:rocket_2"] = "firework_rocket_2",
    ["mcl_fireworks:rocket_3"] = "firework_rocket_3",

    ["mcl_fishing:clownfish_raw"] = "tropical_fish",
    ["mcl_fishing:fish_raw"] = "cod",
    ["mcl_fishing:fish_cooked"] = "cooked_cod",
    ["mcl_fishing:salmon_raw"] = "salmon",
    ["mcl_fishing:salmon_cooked"] = "cooked_salmon",
    ["mcl_fishing:pufferfish_raw"] = "pufferfish",

    ["mcl_flowers:tulip_red"] = "red_tulip",
    ["mcl_flowers:tulip_orange"] = "orange_tulip",
    ["mcl_flowers:tulip_white"] = "white_tulip",
    ["mcl_flowers:tulip_pink"] = "pink_tulip",

    ["mcl_heads:creeper"] = "creeper_head",
    ["mcl_heads:skeleton"] = "skeleton_skull",
    ["mcl_heads:steve"] = "player_head",
    ["mcl_heads:wither_skeleton"] = "wither_skeleton_skull",
    ["mcl_heads:zombie"] = "zombie_head",

    ["mcl_jukebox:record_13"] = "music_disc_13",
    ["mcl_jukebox:record_blocks"] = "music_disc_blocks",
    ["mcl_jukebox:record_chirp"] = "music_disc_chirp",
    ["mcl_jukebox:record_far"] = "music_disc_far",
    ["mcl_jukebox:record_mall"] = "music_disc_mall",
    ["mcl_jukebox:record_mellohi"] = "music_disc_mellohi", --SynthGroove is my least favorite
    ["mcl_jukebox:record_strad"] = "music_disc_strad",
    ["mcl_jukebox:record_wait"] = "music_disc_wait",

    ["mcl_lanterns:lantern_floor"] = "lantern",
    ["mcl_lanterns:soul_lantern_floor"] = "soul_lantern",

    ["mcl_lightning_rods:rod"] = "lightning_rod",

    ["mcl_mangrove:mangrove_mud_roots"] = "muddy_mangrove_roots",
    ["mcl_mangrove:mangrove_stripped_bark"] = "stripped_mangrove_wood",
    ["mcl_mangrove:mangrove_stripped_trunk"] = "stripped_mangrove_log",
    ["mcl_mangrove:mangrove_tree"] = "mangrove_log",
    ["mcl_mangrove:mangrove_bark"] = "mangrove_wood",
    ["mcl_mangrove:mangrove_wood"] = "mangrove_planks",
    ["mcl_mangrove:mangrove_wood_fence"] = "mangrove_fence",
    ["mcl_mangrove:mangrove_wood_fence_gate"] = "mangrove_fence_gate",
    ["mcl_mangrove:mangroveleaves"] = "mangrove_leaves",
    ["mcl_mangrove:propagule"] = "mangrove_propagule",

    ["mcl_maps:empty_map"] = "map",

    ["mcl_minecarts:golden_rail"] = "powered_rail",
    
    ["mcl_mobitems:gold_horse_armor"] = "golden_horse_armor",
    ["mcl_mobitems:slimeball"] = "slime_ball",

    ["mcl_mobs:nametag"] = "name_tag",

    ["mcl_monster_eggs:monster_egg_cobble"] = "infested_cobblestone",
    ["mcl_monster_eggs:monster_egg_stone"] = "infested_stone",
    ["mcl_monster_eggs:monster_egg_stonebrick"] = "infested_stone_bricks",
    ["mcl_monster_eggs:monster_egg_stonebrickcarved"] = "infested_chiseled_stone_bricks",
    ["mcl_monster_eggs:monster_egg_stonebrickmossy"] = "infested_mossy_stone_bricks",

    ["mcl_mushrooms:brown_mushroom_block_cap_111111"] = "brown_mushroom_block",
    ["mcl_mushrooms:red_mushroom_block_cap_111111"] = "red_mushroom_block",
    ["mcl_mushrooms:brown_mushroom_block_stem"] = "brown_mushroom_stem",
    ["mcl_mushrooms:red_mushroom_block_stem"] = "red_mushroom_stem",
    ["mcl_mushrooms:mushroom_brown"] = "brown_mushroom",
    ["mcl_mushrooms:mushroom_red"] = "red_mushroom",

    ["mcl_nether:magma"] = "magma_block",
    ["mcl_nether:netherbrick"] = "nether_brick",
    ["mcl_nether:nether_brick"] = "nether_bricks",
    ["mcl_nether:nether_wart_item"] = "nether_wart",
    ["mcl_nether:netheriteblock"] = "netherite_block",
    ["mcl_nether:quartz_chiseled"] = "chiseled_quartz_block",
    ["mcl_nether:quartz_ore"] = "nether_quartz_ore",
    ["mcl_nether:quartz_smooth"] = "smooth_quartz",
    ["mcl_nether:red_nether_brick"] = "red_nether_bricks",

    ["mcl_observers:observer_off"] = "observer",

    ["mcl_ocean:prismarine_brick"] = "prismarine_bricks",
    ["mcl_ocean:prismarine_dark"] = "dark_prismarine",
    ["mcl_ocean:sea_pickle_1_dead_brain_coral_block"] = "sea_pickle",

    ["mcl_potions:awkward"] = "awkward_potion",
    ["mcl_potions:awkward_lingering"] = "lingering_awkward_potion",
    ["mcl_potions:awkward_splash"] = "splash_awkward_potion",
    ["mcl_potions:fire_resistance"] = "fire_resistance_potion",
    ["mcl_potions:fire_resistance_lingering"] = "lingering_fire_resistance_potion",
    ["mcl_potions:fire_resistance_splash"] = "splash_fire_resistance_potion",
    ["mcl_potions:fire_resistance_arrow"] = "fire_resistance_tipped_arrow",
    ["mcl_potions:fire_resistance_plus"] = "fire_resistance_plus_potion",
    ["mcl_potions:fire_resistance_plus_lingering"] = "lingering_fire_resistance_plus_potion",
    ["mcl_potions:fire_resistance_plus_splash"] = "splash_fire_resistance_plus_potion",
    ["mcl_potions:fire_resistance_plus_arrow"] = "fire_resistance_plus_tipped_arrow",
    ["mcl_potions:harming"] = "harming_potion",
    ["mcl_potions:harming_lingering"] = "lingering_harming_potion",
    ["mcl_potions:harming_splash"] = "splash_harming_potion",
    ["mcl_potions:harming_arrow"] = "harming_tipped_arrow",
    ["mcl_potions:harming_2"] = "harming_2_potion",
    ["mcl_potions:harming_2_lingering"] = "lingering_harming_2_potion",
    ["mcl_potions:harming_2_splash"] = "splash_harming_2_potion",
    ["mcl_potions:harming_2_arrow"] = "harming_2_tipped_arrow",
    ["mcl_potions:healing"] = "healing_potion",
    ["mcl_potions:healing_lingering"] = "lingering_healing_potion",
    ["mcl_potions:healing_splash"] = "splash_healing_potion",
    ["mcl_potions:healing_arrow"] = "healing_tipped_arrow",
    ["mcl_potions:healing_2"] = "healing_2_potion",
    ["mcl_potions:healing_2_lingering"] = "lingering_healing_2_potion",
    ["mcl_potions:healing_2_splash"] = "splash_healing_2_potion",
    ["mcl_potions:healing_2_arrow"] = "healing_2_tipped_arrow",
    ["mcl_potions:invisibility"] = "invisibility_potion",
    ["mcl_potions:invisibility_lingering"] = "lingering_invisibility_potion",
    ["mcl_potions:invisibility_splash"] = "splash_invisibility_potion",
    ["mcl_potions:invisibility_arrow"] = "invisibility_tipped_arrow",
    ["mcl_potions:invisibility_plus"] = "invisibility_plus_potion",
    ["mcl_potions:invisibility_plus_lingering"] = "lingering_invisibility_plus_potion",
    ["mcl_potions:invisibility_plus_splash"] = "splash_invisibility_plus_potion",
    ["mcl_potions:invisibility_plus_arrow"] = "invisibility_plus_tipped_arrow",
    ["mcl_potions:leaping"] = "leaping_potion",
    ["mcl_potions:leaping_lingering"] = "lingering_leaping_potion",
    ["mcl_potions:leaping_splash"] = "splash_leaping_potion",
    ["mcl_potions:leaping_arrow"] = "leaping_tipped_arrow",
    ["mcl_potions:leaping_plus"] = "leaping_plus_potion",
    ["mcl_potions:leaping_plus_lingering"] = "lingering_leaping_plus_potion",
    ["mcl_potions:leaping_plus_splash"] = "splash_leaping_plus_potion",
    ["mcl_potions:leaping_plus_arrow"] = "leaping_plus_tipped_arrow",
    ["mcl_potions:leaping_2"] = "leaping_2_potion",
    ["mcl_potions:leaping_2_lingering"] = "lingering_leaping_2_potion",
    ["mcl_potions:leaping_2_splash"] = "splash_leaping_2_potion",
    ["mcl_potions:leaping_2_arrow"] = "leaping_2_tipped_arrow",
    ["mcl_potions:poison"] = "poison_potion",
    ["mcl_potions:poison_lingering"] = "lingering_poison_potion",
    ["mcl_potions:poison_splash"] = "splash_poison_potion",
    ["mcl_potions:poison_arrow"] = "poison_tipped_arrow",
    ["mcl_potions:poison_plus"] = "poison_plus_potion",
    ["mcl_potions:poison_plus_lingering"] = "lingering_poison_plus_potion",
    ["mcl_potions:poison_plus_splash"] = "splash_poison_plus_potion",
    ["mcl_potions:poison_plus_arrow"] = "poison_plus_tipped_arrow",
    ["mcl_potions:poison_2"] = "poison_2_potion",
    ["mcl_potions:poison_2_lingering"] = "lingering_poison_2_potion",
    ["mcl_potions:poison_2_splash"] = "splash_poison_2_potion",
    ["mcl_potions:poison_2_arrow"] = "poison_2_tipped_arrow",
    ["mcl_potions:regeneration"] = "regeneration_potion",
    ["mcl_potions:regeneration_lingering"] = "lingering_regeneration_potion",
    ["mcl_potions:regeneration_splash"] = "splash_regeneration_potion",
    ["mcl_potions:regeneration_arrow"] = "regeneration_tipped_arrow",
    ["mcl_potions:regeneration_plus"] = "regeneration_plus_potion",
    ["mcl_potions:regeneration_plus_lingering"] = "lingering_regeneration_plus_potion",
    ["mcl_potions:regeneration_plus_splash"] = "splash_regeneration_plus_potion",
    ["mcl_potions:regeneration_plus_arrow"] = "regeneration_plus_tipped_arrow",
    ["mcl_potions:regeneration_2"] = "regeneration_2_potion",
    ["mcl_potions:regeneration_2_lingering"] = "lingering_regeneration_2_potion",
    ["mcl_potions:regeneration_2_splash"] = "splash_regeneration_2_potion",
    ["mcl_potions:regeneration_2_arrow"] = "regeneration_2_tipped_arrow",
    ["mcl_potions:slowness"] = "slowness_potion",
    ["mcl_potions:slowness_lingering"] = "lingering_slowness_potion",
    ["mcl_potions:slowness_splash"] = "splash_slowness_potion",
    ["mcl_potions:slowness_arrow"] = "slowness_tipped_arrow",
    ["mcl_potions:slowness_plus"] = "slowness_plus_potion",
    ["mcl_potions:slowness_plus_lingering"] = "lingering_slowness_plus_potion",
    ["mcl_potions:slowness_plus_splash"] = "splash_slowness_plus_potion",
    ["mcl_potions:slowness_plus_arrow"] = "slowness_plus_tipped_arrow",
    ["mcl_potions:slowness_2"] = "slowness_2_potion",
    ["mcl_potions:slowness_2_lingering"] = "lingering_slowness_2_potion",
    ["mcl_potions:slowness_2_splash"] = "splash_slowness_2_potion",
    ["mcl_potions:slowness_2_arrow"] = "slowness_2_tipped_arrow",
    ["mcl_potions:speckled_melon"] = "glistering_melon_slice",
    ["mcl_potions:swiftness"] = "swiftness_potion",
    ["mcl_potions:swiftness_lingering"] = "lingering_swiftness_potion",
    ["mcl_potions:swiftness_splash"] = "splash_swiftness_potion",
    ["mcl_potions:swiftness_arrow"] = "swiftness_tipped_arrow",
    ["mcl_potions:swiftness_plus"] = "swiftness_plus_potion",
    ["mcl_potions:swiftness_plus_lingering"] = "lingering_swiftness_plus_potion",
    ["mcl_potions:swiftness_plus_splash"] = "splash_swiftness_plus_potion",
    ["mcl_potions:swiftness_plus_arrow"] = "swiftness_plus_tipped_arrow",
    ["mcl_potions:swiftness_2"] = "swiftness_2_potion",
    ["mcl_potions:swiftness_2_lingering"] = "lingering_swiftness_2_potion",
    ["mcl_potions:swiftness_2_splash"] = "splash_swiftness_2_potion",
    ["mcl_potions:swiftness_2_arrow"] = "swiftness_2_tipped_arrow",
    ["mcl_potions:thick"] = "thick_potion",
    ["mcl_potions:thick_lingering"] = "lingering_thick_potion",
    ["mcl_potions:thick_splash"] = "splash_thick_potion",
    ["mcl_potions:water"] = "water_bottle", --I don't know...
    ["mcl_potions:water_lingering"] = "lingering_water_bottle",
    ["mcl_potions:water_splash"] = "splash_water_bottle",
    ["mcl_potions:water_breathing"] = "water_breathing_potion",
    ["mcl_potions:water_breathing_lingering"] = "lingering_water_breathing_potion",
    ["mcl_potions:water_breathing_splash"] = "splash_water_breathing_potion",
    ["mcl_potions:water_breathing_arrow"] = "water_breathing_tipped_arrow",
    ["mcl_potions:water_breathing_plus"] = "water_breathing_plus_potion",
    ["mcl_potions:water_breathing_plus_lingering"] = "lingering_water_breathing_plus_potion",
    ["mcl_potions:water_breathing_plus_splash"] = "splash_water_breathing_plus_potion",
    ["mcl_potions:water_breathing_plus_arrow"] = "water_breathing_plus_tipped_arrow",

    ["mcl_sculk:catalyst"] = "sculk_catalyst",
    ["mcl_sculk:vein"] = "sculk_vein",
    
    ["mcl_signs:wall_sign"] = "oak_sign",
    ["mcl_signs:wall_sign_acaciawood"] = "acacia_sign",
    ["mcl_signs:wall_sign_birchwood"] = "birch_sign",
    ["mcl_signs:wall_sign_cherrywood"] = "cherry_sign",
    ["mcl_signs:wall_sign_darkwood"] = "dark_oak_sign",
    ["mcl_signs:wall_sign_junglewood"] = "jungle_sign",
    ["mcl_signs:wall_sign_mangrove_wood"] = "mangrove_sign",
    ["mcl_signs:wall_sign_sprucewood"] = "spruce_sign",
    ["mcl_signs:wall_sign_bamboo"] = "bamboo_sign",
    ["mcl_signs:wall_sign_crimson_hyphae_wood"] = "crimson_sign",
    ["mcl_signs:wall_sign_crimson_warped_wood"] = "warped_sign",

    ["mcl_smithing_table:table"] = "smithing_table", --is 'enchanting_table' and 'smithing_table' too hard?
    ["mcl_sponges:sponge_wet"] = "wet_sponge",
    ["mcl_sponges:sponge_wet_river_water"] = "river_water_wet_sponge", --IDK...

    --slab/stair aliases registered automatically later
    
    ["mcl_sus_stew:stew"] = "suspicious_stew",

    ["mcl_target:target_off"] = "target",

    ["mcl_tools:sword_diamond"] = "diamond_sword",
    ["mcl_tools:sword_gold"] = "golden_sword",
    ["mcl_tools:sword_iron"] = "iron_sword",
    ["mcl_tools:sword_netherite"] = "netherite_sword",
    ["mcl_tools:sword_stone"] = "stone_sword",
    ["mcl_tools:sword_wood"] = "wooden_sword",
    ["mcl_tools:pick_diamond"] = "diamond_pickaxe",
    ["mcl_tools:pick_gold"] = "golden_pickaxe",
    ["mcl_tools:pick_iron"] = "iron_pickaxe",
    ["mcl_tools:pick_netherite"] = "netherite_pickaxe",
    ["mcl_tools:pick_stone"] = "stone_pickaxe",
    ["mcl_tools:pick_wood"] = "wooden_pickaxe",
    ["mcl_tools:axe_diamond"] = "diamond_axe",
    ["mcl_tools:axe_gold"] = "golden_axe",
    ["mcl_tools:axe_iron"] = "iron_axe",
    ["mcl_tools:axe_netherite"] = "netherite_axe",
    ["mcl_tools:axe_stone"] = "stone_axe",
    ["mcl_tools:axe_wood"] = "wooden_axe",
    ["mcl_tools:shovel_diamond"] = "diamond_shovel",
    ["mcl_tools:shovel_gold"] = "golden_shovel",
    ["mcl_tools:shovel_iron"] = "iron_shovel",
    ["mcl_tools:shovel_netherite"] = "netherite_shovel",
    ["mcl_tools:shovel_stone"] = "stone_shovel",
    ["mcl_tools:shovel_wood"] = "wooden_shovel",

    ["mcl_totems:totem"] = "totem_of_undying",

    ["mcl_villages:tool"] = "village_tool",

    ["mcl_walls:andesite"] = "andesite_wall",
    ["mcl_walls:brick"] = "brick_wall",
    ["mcl_walls:cobble"] = "cobblestone_wall",
    ["mcl_walls:diorite"] = "diorite_wall",
    ["mcl_walls:endbricks"] = "end_stone_brick_wall",
    ["mcl_walls:granite"] = "granite_wall",
    ["mcl_walls:mossycobble"] = "mossy_cobblestone_wall",
    ["mcl_walls:mudbrick"] = "mud_brick_wall",
    ["mcl_walls:netherbrick"] = "nether_brick_wall",
    ["mcl_walls:prismarine"] = "prismarine_wall",
    ["mcl_walls:rednetherbrick"] = "red_nether_brick_wall",
    ["mcl_walls:redsandstone"] = "red_sandstone_wall",
    ["mcl_walls:sandstone"] = "sandstone_wall",
    ["mcl_walls:stonebrick"] = "stone_brick_wall",
    ["mcl_walls:stonebrickmossy"] = "mossy_stone_brick_wall",

    ["mcl_wool:black"] = "black_wool",
    ["mcl_wool:blue"] = "blue_wool",
    ["mcl_wool:brown"] = "brown_wool",
    ["mcl_wool:cyan"] = "cyan_wool",
    ["mcl_wool:dark_green"] = "green_wool", --WHYYYYYY
    ["mcl_wool:grey"] = "gray_wool",
    ["mcl_wool:light_blue"] = "light_blue_wool",
    ["mcl_wool:green"] = "lime_wool",
    ["mcl_wool:magenta"] = "magenta_wool",
    ["mcl_wool:orange"] = "orange_wool",
    ["mcl_wool:pink"] = "pink_wool",
    ["mcl_wool:purple"] = "purple_wool",
    ["mcl_wool:red"] = "red_wool",
    ["mcl_wool:silver"] = "light_gray_wool",
    ["mcl_wool:white"] = "white_wool",
    ["mcl_wool:yellow"] = "yellow_wool",
    ["mcl_wool:grey_carpet"] = "gray_carpet",
    ["mcl_wool:silver_carpet"] = "light_gray_carpet",

    ["mesecons:wire_00000000_off"] = "redstone", --Maybe unnecessary?

    ["mesecons_button:button_wood_off"] = "oak_button",
    ["mesecons_button:button_stone_off"] = "stone_button",
    ["mesecons_button:button_polished_blackstone_off"] = "polished_blackstone_button",
    ["mesecons_button:button_acaciawood_off"] = "acacia_button",
    ["mesecons_button:button_birchwood_off"] = "birch_button",
    ["mesecons_button:button_cherrywood_off"] = "cherry_button",
    ["mesecons_button:button_darkwood_off"] = "dark_oak_button",
    ["mesecons_button:button_junglewood_off"] = "jungle_button",
    ["mesecons_button:button_mangrove_wood_off"] = "mangrove_button",
    ["mesecons_button:button_sprucewood_off"] = "spruce_button",
    ["mesecons_button:button_bamboo_off"] = "bamboo_button",
    ["mesecons_button:button_crimson_hyphae_wood_off"] = "crimson_button",
    ["mesecons_button:button_crimson_warped_wood_off"] = "warped_button",

    ["mesecons_commandblock:commandblock_off"] = "command_block",

    ["mesecons_delayer:delayer_off_1"] = "repeater",

    ["mesecons_lightstone:lightstone_off"] = "redstone_lamp",

    ["mesecons_noteblock:noteblock"] = "note_block",
    
    ["mesecons_pistons:piston_normal_off"] = "piston",
    ["mesecons_pistons:piston_sticky_off"] = "sticky_piston",

    ["mesecons_pressureplates:pressure_plate_wood_off"] = "oak_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_stone_off"] = "stone_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_polished_blackstone_off"] = "polished_blackstone_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_acaciawood_off"] = "acacia_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_birchwood_off"] = "birch_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_cherrywood_off"] = "cherry_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_darkwood_off"] = "dark_oak_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_junglewood_off"] = "jungle_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_mangrove_wood_off"] = "mangrove_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_sprucewood_off"] = "spruce_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_bamboo_off"] = "bamboo_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_crimson_hyphae_wood_off"] = "crimson_pressure_plate",
    ["mesecons_pressureplates:pressure_plate_crimson_warped_wood_off"] = "warped_pressure_plate",

    ["mesecons_solarpanel:solar_panel_off"] = "daylight_detector",

    ["mesecons_torch:mesecon_torch_on"] = "restone_torch",
    ["mesecons_torch:redstoneblock"] = "redstone_block",
    ["mesecons_walllever:wall_lever_off"] = "lever",

    --Spawn eggs done automatically since more are likely to be added.

    ["xpanes:bar_flat"] = "iron_bars",
    ["xpanes:pane_black_flat"] = "black_stained_glass_pane",
    ["xpanes:pane_blue_flat"] = "blue_stained_glass_pane",
    ["xpanes:pane_brown_flat"] = "brown_stained_glass_pane",
    ["xpanes:pane_cyan_flat"] = "cyan_stained_glass_pane",
    ["xpanes:pane_green_flat"] = "green_stained_glass_pane",
    ["xpanes:pane_gray_flat"] = "gray_stained_glass_pane", --why is it grAy here instead of grEy like everything else???
    ["xpanes:pane_light_blue_flat"] = "light_blue_stained_glass_pane",
    ["xpanes:pane_lime_flat"] = "lime_stained_glass_pane",
    ["xpanes:pane_magenta_flat"] = "magenta_stained_glass_pane",
    ["xpanes:pane_orange_flat"] = "orange_stained_glass_pane",
    ["xpanes:pane_pink_flat"] = "pink_stained_glass_pane",
    ["xpanes:pane_purple_flat"] = "purple_stained_glass_pane",
    ["xpanes:pane_red_flat"] = "red_stained_glass_pane",
    ["xpanes:pane_silver_flat"] = "light_gray_stained_glass_pane",
    ["xpanes:pane_white_flat"] = "white_stained_glass_pane",
    ["xpanes:pane_yellow_flat"] = "yellow_stained_glass_pane",
    ["xpanes:pane_natural_flat"] = "glass_pane",
}

local mob_sub = {
    guardian_elder = "elder_guardian",
    magma_cube_big = "magma_cube",
    pigman = "zombie_pigman",
    slime_big = "slime",
    snowman = "snow_golem",
    villager_zombie = "zombie_villager",
    witherskeleton = "wither_skeleton",
    enderdragon = "ender_dragon",
}

local whitelisted_mods = {
    doc_identifier = true,
    mcl_amethyst = true,
    mcl_anvils = true,
    mcl_armor = true,
    mcl_armor_stand = true,
    mcl_bamboo = true,
    mcl_banners = true,
    mcl_barrels = true,
    mcl_beacons = true,
    mcl_beds = true,
    mcl_blackstone = true,
    mcl_books = true,
    mcl_bows = true,
    mcl_cauldrons = true,
    mcl_chests = true,
    mcl_cherry_blossom = true,
    mcl_clock = true,
    mcl_cocoas = true,
    mcl_colorblocks = true,
    mcl_colors = true,
    mcl_comparators = true,
    mcl_compass = true,
    mcl_composters = true,
    mcl_copper = true,
    mcl_core = true,
    mcl_crafting_table = true,
    mcl_crimson = true,
    mcl_deepslate = true,
    mcl_dispensers = true,
    mcl_doors = true,
    mcl_droppers = true,
    mcl_dye = true,
    mcl_enchanting = true,
    mcl_end = true,
    mcl_experience = true,
    mcl_farming = true,
    mcl_fences = true,
    mcl_fire = true,
    mcl_fireworks = true,
    mcl_fishing = true,
    mcl_fletching_table = true,
    mcl_flowerpots = true,
    mcl_flowers = true,
    mcl_furnaces = true,
    mcl_grindstone = true,
    mcl_hamburger = true,
    mcl_heads = true,
    mcl_honey = true,
    mcl_hoppers = true,
    mcl_itemframes = true,
    mcl_jukebox = true,
    mcl_lanterns = true,
    mcl_lectern = true,
    mcl_lightning_rods = true,
    mcl_loom = true,
    mcl_mangrove = true,
    mcl_maps = true,
    mcl_minecarts = true,
    mcl_mobitems = true,
    mcl_mud = true,
    mcl_mushrooms = true,
    mcl_nether = true,
    mcl_observers = true,
    mcl_ocean = true,
    mcl_paintings = true,
    mcl_potions = true,
    mcl_raw_ores = true,
    mcl_sculk = true,
    mcl_shields = true,
    mcl_signs = true,
    mcl_smithing_table = true,
    mcl_smoker = true,
    mcl_sponges = true,
    mcl_spyglass = true,
    mcl_stairs = true,
    mcl_stonecutter = true,
    mcl_sus_stew = true,
    mcl_target = true,
    mcl_tnt = true,
    mcl_tools = true,
    mcl_throwing = true,
    mcl_torches = true,
    mcl_totems = true,
    mcl_villages = true,
    mcl_walls = true,
    mcl_wool = true,
    mclx_core = true,
    mclx_fences = true,
    mclx_stairs = true,
    mobs_mc = true,
    screwdriver = true,
    xpanes = true,
    mesecons = true,
    mesecons_solarpanel = true,
    mesecons_button = true,
    mesecons_commandblock = true,
    mesecons_pressureplates = true,
    mesecons_delayer = true,
    mesecons_lightstone = true,
    mesecons_noteblock = true,
    mesecons_pistons = true,
    mesecons_torch = true,
    mesecons_walllever = true,
}


local function register_aliases(alias, itemstring)
    if not minetest.registered_aliases["mineclone:"..alias] then
        minetest.register_alias("mineclone:"..alias, itemstring)
    end
    if prefix ~= "mineclone:" and not minetest.registered_aliases[prefix..alias] then
        minetest.register_alias(prefix..alias, itemstring)
    end
end

-- the on_mods_loaded thing may not be necessary.
minetest.register_on_mods_loaded(function()
    for itemstring, def in pairs(minetest.registered_items) do
        local _, _, mod_name, item_name = itemstring:find("([%d_%l]+):([%d_%l]+)")
        --minetest.log(tostring(mod_name))
        --minetest.log(tostring(item_name))
        if whitelisted_mods[mod_name] == true then  --only change MineClone items, not things from other mods
            local new_item_name = aliases[itemstring]
            if new_item_name then
                register_aliases(new_item_name, itemstring)
                if mod_name ~= "mcl_stairs" then --don't check for stair/slab variants if it's already a stair/slab
                    local slab_itemstring = itemstring:gsub("[%d_%l]+:", "mcl_stairs:slab_")
                    if minetest.registered_items[slab_itemstring] then
                        register_aliases(new_item_name.."_slab", slab_itemstring)
                    end
                    local stair_itemstring = itemstring:gsub("[%d_%l]+:", "mcl_stairs:stair_")
                    if minetest.registered_items[stair_itemstring] and stair_itemstring then
                        register_aliases(new_item_name.."_stair", stair_itemstring)
                    end
                end
            elseif mod_name == "mobs_mc" then
                local new_itemstring = ""
                local egg_sub = mob_sub[item_name]
                if egg_sub then
                    new_item_name = egg_sub.."_spawn_egg"
                else
                    new_item_name = item_name.."_spawn_egg"
                end
                register_aliases(new_item_name, itemstring)
            else
                register_aliases(item_name, itemstring)
            end
        end
    end
end)