
minetest.register_node("basic:stone", {
	description = ("stono_on"),
                  drawtype = "glasslike_framed_optional",
	tiles = {"stono.png", "stono_detail.png"},
	paramtype = "light",
	paramtype2 = "glasslikeliquidlevel",
	light_source = 5,
                  drop = "basic:stone 1",
	sunlight_propagates = true,
                  sounds = default.node_sound_glass_defaults(),
                  groups = {cracky = 2, mesecon = 2, mesecon_receptor_off = 1, mesecon_effector_off = 1},
	is_ground_content = false,
mesecons = {effector = {
		action_off = function (pos, node)
			minetest.swap_node(pos, {name = "basic:stone_on", param2 = node.param2})
		end,
		rules = mesecon.rules.wallmounted_get,
	}},
	on_blast = mesecon.on_blastnode,
})

minetest.register_node("basic:stone_on", {
	description = ("stono_off"),
tiles = {{
		name = "basic_stone_on.png",
		animation = {
			type = "vertical_frames",
			aspect_w = 16,
			aspect_h = 16,
			length = 1
		}}
	},
	paramtype = "light",
	light_source = 5,
                  drop = "basic:stone 1",
	sunlight_propagates = true,
	is_ground_content = false,
                  groups = {cracky = 2, not_in_creative_inventory = 1, mesecon_effector_on = 1},
	sounds = default.node_sound_glass_defaults(),
mesecons = {effector = {
		action_on = function (pos, node)
			minetest.swap_node(pos, {name = "basic:stone", param2 = node.param2})
		end,
		rules = mesecon.rules.wallmounted_get,
	}},
	on_blast = mesecon.on_blastnode,
})
--------------------------------------------------------------------

minetest.register_node("basic:spawn", {
	description = ("spawn"),
	drawtype = "glasslike_framed_optional",
	tiles = {"stono.png", "stono_detail.png"},
	paramtype = "light",
	paramtype2 = "glasslikeliquidlevel",
	light_source = 5,
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {cracky = 2},
})

minetest.register_node("basic:gate", {
	description = ("gate"),
	tiles = {"gate.png",},
	light_source = 5,
	is_ground_content = false,
	groups = {cracky = 2},
	collision_box = {
		type = "fixed",
		fixed = {0, 0, 0, 0, 0, 0},
		},
})

minetest.register_node("basic:cube", {
	description = ("simple cube"),
	tiles = {"simple_cube.png",},
	paramtype = "light",
	light_source = 1,
	is_ground_content = false,
	groups = {oddly_breakable_by_hand = 2, cracky = 2},
})
minetest.register_node('basic:ballpoint',{
    description = 'point',
    drawtype = 'mesh',
    mesh = 'ballpoint.obj',
    climbable = true,
    paramtype = "light",
    paramtype2 = "facedir",
    tiles = {"ballpoint.png"},
    inventory_image = "ballpoint_inv.png",
    collision_box = {
    type = "fixed",
    fixed = {0, 0, 0, 0, 0, 0},
    },
    groups = {fleshy = 3, dig_immediate = 3, flammable = 2, food_apple = 1, mesecon = 2},
    on_use = minetest.item_eat(1),
	mesecons = {receptor = {
		state = mesecon.state.on
	}},
	on_blast = mesecon.on_blastnode,
    })
    
minetest.register_node('basic:mega_ballpoint',{
    description = 'power_pelet',
    drawtype = 'mesh',
    mesh = 'mega_ballpoint.obj',
    climbable = true,
    paramtype = "light",
    paramtype2 = "facedir",
    tiles = {"mega_ballpoint.png"},
    drop = "basic:power_pellet",
    inventory_image = "mega_ballpoint_inv.png",
    collision_box = {
    type = "fixed",
    fixed = {0, 0, 0, 0, 0, 0},
    },
    groups = {dig_immediate = 3, mesecon = 2, flammable = 2,},
    on_use = minetest.item_eat(10),
mesecons = {receptor = {
		state = mesecon.state.on
	}},
	on_blast = mesecon.on_blastnode,
    })
    
minetest.register_craft({
output = "basic:mega_ballpoint",
recipe = {
		{"basic:ballpoint", "basic:ballpoint", "basic:ballpoint"},
		{"basic:ballpoint", "basic:ballpoint", "basic:ballpoint"},
		{"basic:ballpoint", "basic:ballpoint", "basic:ballpoint"},
	}

})    

minetest.register_tool("basic:power_pellet", {
	description = ("can kill ghost  "),
	inventory_image = "power_pellet.png",
	tool_capabilities = {
		full_punch_interval = 0.2,
		max_drop_level= 1.2,
		groupcaps={
			snappy={times={[1]=0.1, [2]=0.1, [3]=0.1}, uses= 1.2, maxlevel=1.2},
		},
		damage_groups = {fleshy=5},
	},
	groups = {sword = 1}
})

minetest.register_tool("basic:edit_pick", {
	description = "edit_pickaxe".."\n"..
		"Digs",
	inventory_image = "basic_pick.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=0,
		groupcaps={
			cracky={times={[1]=0.0, [2]=0.0, [3]=0.0}, maxlevel=255},
			crumbly={times={[1]=0.0, [2]=0.0, [3]=0.0}, maxlevel=255},
			snappy={times={[1]=0.0, [2]=0.0, [3]=0.0}, maxlevel=255},
			choppy={times={[1]=0.0, [2]=0.0, [3]=0.0}, maxlevel=255},
			dig_immediate={times={[1]=0.0, [2]=0.0, [3]=0.0}, maxlevel=255},
		},
		damage_groups = {fleshy=100},
	},
})

