
local images = {
	["circuit_demo"] = {
		texture = "mapa.png",
		description = "Display demo",
	},

	["display_demo"] = {
		texture = "mapb.png",
		description = "used as a map"
	}
	
}

for name, def in pairs(images) do
	minetest.register_node("images:" .. name, {
		description = def.description,
		drawtype = "signlike",
		tiles = {
			def.texture
		},
		visual_scale = 3.0,
		inventory_image = def.texture,
		wield_image = def.texture,
		paramtype = "light",
		paramtype2 = "wallmounted",
		sunlight_propagates = true,
		walkable = false,
		selection_box = {
			type = "wallmounted",
		},
		groups = {
			choppy = 1
		}
	})
end
