
-- register bypass priv
minetest.register_privilege("help_game_bypass", {
	description = "to know how to play this game.", give_to_singleplayer = false})

-- create formspec from text file
local function get_formspec()
	local help_game_file = io.open(minetest.get_worldpath().."/help_game.txt", "r")
	local help_game_fs = 'size[12,8.25]'..
		"button_exit[-0.05,7.8;2,1;exit;Close]"
	if help_game_file then
		local help_game = help_game_file:read("*a")
		help_game_file:close()
		help_game_fs = help_game_fs.."textarea[0.25,0;12.1,9;help_game;;"..help_game.."]"
	else
		help_game_fs = help_game_fs.."textarea[0.25,0;12.1,9;help_game;;hi,this a guide to help you to play this game.This game is a pacman inspired game, in this you will get a maze spawner in your inventory.That will spawn a maze when placed, you will also get 4 ghost you have to spawn them too by yourself.Eat all dots.Those give you heal health point. power pellet is used as weapon as it can kill ghost when hit them with it, To win you must eat all dot,by doing this all floor blocks will animate pink and blue, also the message will show that you won the game. After this you can consider yourself a winner.]"
	end
	return help_game_fs
end

-- show help_game formspec on player join, unless player has bypass priv
minetest.register_on_joinplayer(function (player)
	local name = player:get_player_name()
	if minetest.get_player_privs(name).help_game_bypass then
		return
	else
		minetest.show_formspec(name, "help_game", get_formspec())
	end
end)

-- command to display server help_game at any time
minetest.register_chatcommand("help_game", {
	description = "Shows help_game to the player",
	func = function (name)
		local player = minetest.get_player_by_name(name)
		minetest.show_formspec(name, "help_game", get_formspec())	
	end
})
