# PvP Training Bot Mod for Minetest

This Minetest mod introduces customizable practice bots to help players train and improve their PvP (Player vs. Player) skills. Designed for solo practice, the bots simulate realistic combat scenarios with varying difficulty levels and adaptive behavior.

---

## Features

### 1. **Customizable Practice Bots**
- **Easy, Medium, and Difficult Bots**: Train at your own pace with bots of varying difficulty levels.
- **Realistic Behavior**: Bots move, attack, and follow physics like real players, creating an immersive PvP training experience.
- **Unique Animations**: Bots use player-like animations for walking, attacking, and more.

### 2. **Spawner Blocks**
- **Dedicated Spawners**: Spawn bots using special blocks with unique textures for easy identification.
- **Difficulty Levels**:
  - *Easy*: Low health, slow speed, and minimal damage.
  - *Medium*: Balanced health, speed, and damage.
  - *Difficult*: High health, fast speed, and significant damage.

### 3. **Custom Breaker Tool**
- A unique axe is the only tool capable of breaking spawner blocks.
- Hidden from crafting and creative inventory to ensure controlled usage.

---

## How to Use

1. **Place Spawners**:
   - Right-click spawner blocks (`Easy`, `Medium`, `Difficult`) to summon bots.
2. **Fight Bots**:
   - Engage with bots to practice your combat skills. Each bot has unique stats and behavior tailored to its difficulty level.
3. **Admin Controls**:
   - Use the custom axe (`Spawner Breaker`) to manage and remove spawner blocks. The axe is only accessible via admin commands.

---

## Installation

1. Download or clone the repository into your Minetest `mods` folder.
2. Place all textures (e.g., spawner block textures and the custom axe texture) in the `textures` folder.
3. Enable the mod in your Minetest game.

---

## Why Use This Mod?

- **Improve Your PvP Skills**: Hone your combat abilities in a controlled environment.
- **Customizable Training**: Choose bots that match your skill level and gradually increase difficulty.
- **Perfect for Solo Players**: Train anytime without needing another player.

---

## Contributing

Contributions are welcome! If you have ideas for improvements, feel free to submit a pull request or open an issue.

---

## License

This mod is released under the MIT License. Feel free to modify and share as needed.

---

With this mod, you'll always have a reliable sparring partner to sharpen your PvP skills. Get ready to dominate your next battle! 🎮


## Gallery

![screenshot_20241229_143336](https://github.com/user-attachments/assets/f7ea151d-a450-4c5e-8c01-c641d8bccf4f)


![screenshot_20241229_143453](https://github.com/user-attachments/assets/56172fd2-6999-4b47-98be-580f00159b0b)


