-- Node color mapping module for persistent maps
-- Returns a module table with functions to access node colors

local node_colors = {
	-- Ground - Default game
	["default:dirt"] = {134, 96, 67},
	["default:dirt_with_grass"] = {95, 159, 53},
	["default:stone"] = {128, 128, 128},
	["default:sand"] = {194, 178, 128},
	["default:desert_sand"] = {210, 180, 140},
	["default:gravel"] = {136, 126, 126},
	["default:snow"] = {240, 240, 240},
	["default:ice"] = {175, 210, 255},
	["default:desert_stone"] = {180, 140, 100},
	["default:dirt_with_snow"] = {200, 200, 200},
	["default:snowblock"] = {240, 240, 240},
	["default:cobble"] = {100, 100, 100},
	["default:mossycobble"] = {80, 120, 80},
	["default:lava_source"] = {255, 100, 0},
	["default:apple"] = {200, 50, 50},
	["default:junglegrass"] = {40, 80, 20},
	
	-- Ground - MineClone compatibility
	["mcl_core:dirt"] = {134, 96, 67},
	["mcl_core:dirt_with_grass"] = {95, 159, 53},
	["mcl_flowers:tallgrass"] = {95, 159, 53},

	["mcl_core:stone"] = {128, 128, 128},
	["mcl_core:sand"] = {194, 178, 128},
	["mcl_core:redsand"] = {210, 180, 140},
	["mcl_core:gravel"] = {136, 126, 126},
	["mcl_core:snow"] = {240, 240, 240},
	["mcl_core:ice"] = {175, 210, 255},
	["mcl_core:packed_ice"] = {160, 200, 255},
	["mcl_core:snowblock"] = {240, 240, 240},
	["mcl_core:grass_block"] = {95, 159, 53},
	["mcl_core:podzol"] = {90, 70, 50},
	["mcl_core:mycelium"] = {110, 90, 110},
	["mcl_core:coarse_dirt"] = {120, 85, 60},
	
	-- Mapgen aliases - Universal compatibility for all mapgens
	["mapgen_stone"] = {128, 128, 128},
	["mapgen_water_source"] = {38, 92, 255},
	["mapgen_river_water_source"] = {20, 100, 200},
	["mapgen_lava_source"] = {255, 100, 0},
	["mapgen_dirt"] = {134, 96, 67},
	["mapgen_dirt_with_grass"] = {95, 159, 53},
	["mapgen_sand"] = {194, 178, 128},
	["mapgen_gravel"] = {136, 126, 126},
	["mapgen_desert_stone"] = {180, 140, 100},
	["mapgen_desert_sand"] = {210, 180, 140},
	["mapgen_dirt_with_snow"] = {200, 200, 200},
	["mapgen_snowblock"] = {240, 240, 240},
	["mapgen_snow"] = {240, 240, 240},
	["mapgen_ice"] = {175, 210, 255},
	["mapgen_tree"] = {101, 84, 50},
	["mapgen_leaves"] = {60, 100, 30},
	["mapgen_apple"] = {200, 50, 50},
	["mapgen_jungletree"] = {120, 90, 50},
	["mapgen_jungleleaves"] = {50, 90, 30},
	["mapgen_junglegrass"] = {40, 80, 20},
	["mapgen_pine_tree"] = {85, 70, 45},
	["mapgen_pine_needles"] = {45, 80, 25},
	["mapgen_cobble"] = {100, 100, 100},
	["mapgen_mossycobble"] = {80, 120, 80},
	
	-- Water - Default game
	["default:water_source"] = {38, 92, 255},
	["default:water_flowing"] = {38, 92, 255},
	["default:river_water_source"] = {20, 100, 200},
	
	-- Water - MineClone compatibility
	["mcl_core:water_source"] = {38, 92, 255},
	["mcl_core:water_flowing"] = {38, 92, 255},
	["mclx_core:river_water_source"] = {20, 100, 200},
	["mclx_core:river_water_flowing"] = {20, 100, 200},
	
	-- Trees - Default game
	["default:tree"] = {101, 84, 50},
	["default:leaves"] = {60, 100, 30},
	["default:pine_tree"] = {85, 70, 45},
	["default:pine_needles"] = {45, 80, 25},
	["default:jungletree"] = {120, 90, 50},
	["default:jungleleaves"] = {50, 90, 30},
	
	-- Trees - MineClone compatibility
	["mcl_core:tree"] = {101, 84, 50},  -- Oak
	["mcl_core:leaves"] = {60, 100, 30},  -- Oak leaves
	["mcl_trees:leaves_jungle"] = {60, 100, 30},  -- Oak leaves

	["mcl_core:sprucetree"] = {85, 70, 45},  -- Spruce
	["mcl_core:spruceleaves"] = {45, 80, 25},  -- Spruce leaves
	["mcl_core:birchtree"] = {220, 220, 180},  -- Birch
	["mcl_core:birchleaves"] = {80, 120, 50},  -- Birch leaves
	["mcl_core:jungletree"] = {120, 90, 50},  -- Jungle
	["mcl_core:jungleleaves"] = {50, 90, 30},  -- Jungle leaves
	["mcl_core:acaciatree"] = {160, 100, 60},  -- Acacia
	["mcl_core:acacialeaves"] = {90, 110, 40},  -- Acacia leaves
	["mcl_core:darktree"] = {60, 40, 20},  -- Dark oak
	["mcl_core:darkleaves"] = {40, 70, 20},  -- Dark oak leaves
	
	-- Ores - Default game
	["default:stone_with_coal"] = {64, 64, 64},
	["default:stone_with_iron"] = {140, 120, 110},
	["default:stone_with_gold"] = {220, 180, 50},
	
	-- Ores - MineClone compatibility
	["mcl_core:stone_with_coal"] = {64, 64, 64},
	["mcl_core:stone_with_iron"] = {140, 120, 110},
	["mcl_core:stone_with_gold"] = {220, 180, 50},
	["mcl_core:stone_with_diamond"] = {100, 200, 255},
	["mcl_core:stone_with_emerald"] = {50, 200, 100},
	["mcl_core:stone_with_lapis"] = {50, 100, 200},
	["mcl_core:stone_with_redstone"] = {200, 50, 50},
	
	-- Additional MineClone blocks
	["mcl_core:cobble"] = {100, 100, 100},
	["mcl_core:mossycobble"] = {80, 120, 80},
	["mcl_core:stonebrick"] = {120, 120, 120},
	["mcl_core:granite"] = {150, 100, 80},
	["mcl_core:andesite"] = {130, 130, 130},
	["mcl_core:diorite"] = {180, 180, 180},
	["mcl_core:obsidian"] = {20, 10, 30},
	["mcl_core:bedrock"] = {40, 40, 40},
	["mcl_core:clay"] = {160, 160, 180},
	["mcl_nether:netherrack"] = {100, 50, 50},
	["mcl_nether:soul_sand"] = {80, 70, 60},
	["mcl_end:end_stone"] = {220, 220, 180},
	
	-- Farmland and crops
	["mcl_farming:soil"] = {120, 80, 50},
	["mcl_farming:soil_wet"] = {100, 70, 40},
	["mcl_core:grass_path"] = {140, 120, 80},
	
	-- Stairs (for mapgen compatibility)
	["stairs:stair_cobble"] = {100, 100, 100},
	["stairs:stair_desert_stone"] = {180, 140, 100},
	
	-- NodeCore compatibility
	["nc_terrain:dirt"] = {134, 96, 67},
	["nc_terrain:dirt_with_grass"] = {95, 159, 53},
	["nc_terrain:stone"] = {128, 128, 128},
	["nc_terrain:sand"] = {194, 178, 128},
	["nc_terrain:gravel"] = {136, 126, 126},
	["nc_terrain:cobble"] = {100, 100, 100},
	["nc_terrain:water_source"] = {38, 92, 255},
	["nc_terrain:water_flowing"] = {38, 92, 255},
	["nc_terrain:lava_source"] = {255, 100, 0},
	["nc_terrain:lava_flowing"] = {255, 80, 0},
	["nc_terrain:ice"] = {175, 210, 255},
	["nc_terrain:snow"] = {240, 240, 240},
	["nc_terrain:clay"] = {160, 160, 180},
	["nc_terrain:annealed"] = {150, 150, 150},
	["nc_terrain:pumice"] = {200, 190, 180},
	
	-- NodeCore trees and vegetation
	["nc_tree:tree"] = {101, 84, 50},
	["nc_tree:leaves"] = {60, 100, 30},
	["nc_tree:root"] = {80, 60, 40},
	["nc_tree:bark"] = {90, 70, 45},
	["nc_flora:grass"] = {70, 120, 40},
	["nc_flora:flower"] = {200, 100, 150},
	["nc_flora:turf"] = {85, 140, 45},
	
	-- NodeCore ores and minerals
	["nc_ore:coal"] = {64, 64, 64},
	["nc_ore:iron"] = {140, 120, 110},
	["nc_ore:copper"] = {180, 120, 80},
	["nc_terrain:stone_with_coal"] = {80, 80, 80},
	["nc_terrain:stone_with_iron"] = {140, 120, 110},
	["nc_terrain:stone_with_copper"] = {160, 130, 90},
	
	-- NodeCore additional blocks
	["nc_concrete:concrete"] = {160, 160, 160},
	["nc_fire:ash"] = {80, 80, 80},
	["nc_lode:stone"] = {110, 110, 110},
	["nc_lux:cobble"] = {120, 120, 120},
}

-- Module table to return
local nodecolors = {}

-- Function to get color for a node
function nodecolors.get_color(nodename)
	return node_colors[nodename] or {100, 100, 100}
end

-- Function to add or update a node color
function nodecolors.set_color(nodename, color)
	node_colors[nodename] = color
end

-- Function to check if a node has a defined color
function nodecolors.has_color(nodename)
	return node_colors[nodename] ~= nil
end

-- Function to get all defined node colors (for debugging/inspection)
function nodecolors.get_all_colors()
	local copy = {}
	for k, v in pairs(node_colors) do
		copy[k] = {v[1], v[2], v[3]}  -- Create a copy of the color array
	end
	return copy
end

return nodecolors
