minetest.register_on_mods_loaded(function()
    
    -- Left hand punch animation
    charged_models.create_animation("left_punch", {
        trigger = "press_place",  -- Right click for left punch
        transform_keyframes = {
            {time = 0.0, position = {x = -3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}},
            {time = 0.15, position = {x = -2, y = 13, z = 1}, rotation = {x = -30, y = -15, z = 0}, easing = "ease_out"},
            {time = 0.3, position = {x = -3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in"}
        }
    })
    
    -- Right hand punch animation
    charged_models.create_animation("right_punch", {
        trigger = "press_dig",  -- Left click for right punch
        transform_keyframes = {
            {time = 0.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}},
            {time = 0.15, position = {x = 2, y = 13, z = 1}, rotation = {x = -30, y = 15, z = 0}, easing = "ease_out"},
            {time = 0.3, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in"}
        }
    })
    
    -- Idle breathing animation for left hand
    charged_models.create_animation("left_idle", {
        trigger = "none",
        loop = true,
        loop_speed = 1.0,
        transform_keyframes = {
            {time = 0.0, position = {x = -3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"},
            {time = 1.0, position = {x = -3, y = 13.15, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"},
            {time = 2.0, position = {x = -3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"}
        }
    })
    
    -- Idle breathing animation for right hand
    charged_models.create_animation("right_idle", {
        trigger = "none",
        loop = true,
        loop_speed = 1.0,
        transform_keyframes = {
            {time = 0.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"},
            {time = 1.0, position = {x = 3, y = 13.15, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"},
            {time = 2.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"}
        }
    })
    
    -- Dual wield bare fists config
    charged_models.create_model_config("bare_fists", {
        -- Left hand
        {
            mesh = "left_hand.gltf",
            textures = {"hand_skin.png"},
            position = {x = -3, y = 13, z = 3},
            scale = {x = 10, y = 10, z = 10},
            animations = {
                idle = "left_idle",
                punch = "left_punch"
            }
        },
        -- Right hand
        {
            mesh = "hand.gltf",
            textures = {"hand_skin.png"},
            position = {x = 3, y = 13, z = 3},
            scale = {x = 10, y = 10, z = 10},
            animations = {
                idle = "right_idle",
                punch = "right_punch"
            }
        }
    })
    
    -- Register the bare fists item
    charged_models.register_item_model("charged_models:bare_fists", "bare_fists")
    
end)

-- Register the bare fists tool/item
minetest.register_tool("charged_models:bare_fists", {
    description = "Bare Fists\nLeft click: Right punch\nRight click: Left punch",
    inventory_image = "default_tool_hand.png",  -- Use a fist icon if you have one
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 0,
        groupcaps = {
            crumbly = {times = {[2] = 3.00, [3] = 0.70}, uses = 0, maxlevel = 1},
            snappy = {times = {[3] = 0.40}, uses = 0, maxlevel = 1},
            oddly_breakable_by_hand = {times = {[1] = 3.50, [2] = 2.00, [3] = 0.70}, uses = 0, maxlevel = 3}
        },
        damage_groups = {fleshy = 1},
    },
    sound = {breaks = "default_tool_breaks"},
})
