-- Quick Example Configurations for Charged Models API

-- Charged attack with particle effects on release
minetest.register_on_mods_loaded(function()
    
    -- Charge-up animation (hold to charge)
    charged_models.create_animation("charge_attack", {
        trigger = "hold_dig",
        hold_behavior = "hold_last_frame",  -- Stay at max charge
        transform_keyframes = {
            {time = 0.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}},
            {time = 0.5, position = {x = 2, y = 14, z = 3}, rotation = {x = -30, y = 0, z = 0}, easing = "ease_in"},
            {time = 1.0, position = {x = 1, y = 15, z = 4}, rotation = {x = -60, y = 0, z = 0}, easing = "ease_in"},
            {time = 2.0, position = {x = 0, y = 16, z = 5}, rotation = {x = -90, y = 0, z = 0}, easing = "ease_in"}  -- Full charge at 2 seconds
        },
        on_hold = function(self)
            -- Spawn charging particles while holding
            local parent = self.object:get_attach()
            if parent then
                local pos = parent:get_pos()
                pos.y = pos.y + 2
                
                minetest.add_particlespawner({
                    amount = 3,
                    time = 0.1,
                    minpos = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
                    maxpos = {x = pos.x + 0.5, y = pos.y + 0.5, z = pos.z + 0.5},
                    minvel = {x = -0.5, y = 0.5, z = -0.5},
                    maxvel = {x = 0.5, y = 1.5, z = 0.5},
                    minacc = {x = 0, y = 0, z = 0},
                    maxacc = {x = 0, y = 0, z = 0},
                    minexptime = 0.5,
                    maxexptime = 1.0,
                    minsize = 1,
                    maxsize = 2,
                    collisiondetection = false,
                    glow = 14,
                    texture = "default_cloud.png^[colorize:#00ffff:200"
                })
            end
        end
    })
    
    -- Release animation with particle explosion
    charged_models.create_animation("release_attack", {
        trigger = "release_dig",
        transform_keyframes = {
            {time = 0.0, position = {x = 0, y = 16, z = 5}, rotation = {x = -90, y = 0, z = 0}},
            {time = 0.1, position = {x = 3, y = 14, z = 2}, rotation = {x = 30, y = 0, z = 0}, easing = "ease_out"},
            {time = 0.3, position = {x = 5, y = 12, z = 1}, rotation = {x = 60, y = 0, z = 0}, easing = "ease_in"},
            {time = 0.5, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"}
        },
        on_start = function(self)
            -- Spawn explosion particles on release
            local parent = self.object:get_attach()
            if not parent then return end
            
            local pos = parent:get_pos()
            local dir = parent:get_look_dir()
            
            -- Calculate impact position in front of player
            local impact_pos = {
                x = pos.x + dir.x * 3,
                y = pos.y + 1.5 + dir.y * 3,
                z = pos.z + dir.z * 3
            }
            
            -- Large particle explosion
            minetest.add_particlespawner({
                amount = 50,
                time = 0.1,
                minpos = impact_pos,
                maxpos = impact_pos,
                minvel = {x = -3, y = -3, z = -3},
                maxvel = {x = 3, y = 3, z = 3},
                minacc = {x = 0, y = -5, z = 0},
                maxacc = {x = 0, y = -5, z = 0},
                minexptime = 0.5,
                maxexptime = 1.5,
                minsize = 2,
                maxsize = 4,
                collisiondetection = true,
                collision_removal = true,
                glow = 14,
                texture = "default_cloud.png^[colorize:#ff0000:200"
            })
            
            -- Shockwave ring
            minetest.add_particlespawner({
                amount = 30,
                time = 0.1,
                minpos = {x = impact_pos.x, y = impact_pos.y - 0.5, z = impact_pos.z},
                maxpos = {x = impact_pos.x, y = impact_pos.y + 0.5, z = impact_pos.z},
                minvel = {x = -4, y = 0, z = -4},
                maxvel = {x = 4, y = 0, z = 4},
                minacc = {x = 0, y = 0, z = 0},
                maxacc = {x = 0, y = 0, z = 0},
                minexptime = 0.3,
                maxexptime = 0.8,
                minsize = 3,
                maxsize = 5,
                collisiondetection = false,
                glow = 12,
                texture = "default_cloud.png^[colorize:#ffff00:150"
            })
            
            -- Play sound effect
            minetest.sound_play("default_dig_cracky", {
                pos = impact_pos,
                gain = 1.0,
                max_hear_distance = 32,
                pitch = 0.7
            })
        end,
        on_complete = function(self)
            minetest.log("action", "Charged attack completed!")
        end
    })
    
    -- Idle breathing animation
    charged_models.create_animation("idle_breath", {
        trigger = "none",
        loop = true,
        transform_keyframes = {
            {time = 0.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"},
            {time = 1.5, position = {x = 3, y = 13.2, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"},
            {time = 3.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"}
        }
    })
    
    -- Create the charged weapon model
    charged_models.create_model_config("charged_blade", {
        mesh = "sword.gltf",
        textures = {"charged_models_cold.png"},
        position = {x = 3, y = 13, z = 3},
        scale = {x = 10, y = 10, z = 10},
        animations = {
            idle = "idle_breath",
            charge = "charge_attack",
            release = "release_attack"
        }
    })
    
    -- Register to item
    charged_models.register_item_model("charged_models:charged_blade", "charged_blade")
    
end)

-- Register the weapon item
minetest.register_tool("charged_models:charged_blade", {
    description = "Charged Blade\nHold left click to charge\nRelease to unleash devastating attack!",
    inventory_image = "charged_models_cold.png^[colorize:#00ffff:100",
    tool_capabilities = {
        full_punch_interval = 2.0,
        max_drop_level = 3,
        groupcaps = {
            cracky = {times = {[1] = 1.0, [2] = 0.5, [3] = 0.3}, uses = 30, maxlevel = 3},
        },
        damage_groups = {fleshy = 10},
    },
})

