# Item Model Animations API
![Screenshot showing two hands at once](images/two-hands.jpeg "title")

A comprehensive modpack for Luanti that provides a complete solution for creating animated 3D item models with sophisticated behavior profiles. This modpack combines two powerful mods to give you full control over how items appear and behave in your game.

## What This Does



**Item Model Animations API** enables you to:

- **Replace 2D item sprites with animated 3D models** - Transform flat inventory icons into dynamic, living models when held
- **Apply behavior templates to items** - Use reusable profiles to modify item properties across single items or entire groups
- **Create interactive animations** - Build charge attacks, mining motions, idle breathing, and custom actions triggered by player input
- **Hide default item rendering** - Automatically suppress the default held item display when using custom models

![Screenshot showing a hand holding a brick block/node as a house is being built](images/node-block-hold.jpeg "title")


This modpack is perfect for creating:
- Custom weapons with attack animations
- Tools with realistic usage motions
- Magic items with charge-up effects
- Dual-wielded items
- Any item that needs more personality than a static 2D sprite


![Screenshot showing two swords at once](images/dual-sword-hold.jpeg "title")

## Included Mods


### Charged Models
The animation engine that handles:
- 3D model attachment and rendering
- Keyframe-based animation system
- Input-driven triggers (dig, place, jump, etc.)
- Multi-model support for complex items
- Particle effects and callbacks
- Automatic 3D cube display for items without custom models

### Item Profiles
The behavior management system that provides:
- Reusable item modification templates
- Bulk operations across multiple items
- Filter functions for selective application
- Built-in "invisible" profile that hides default held items
- Original state preservation when profiles are removed

![Screenshot showing a hand holding a flaming torch](images/torch-3rd-person.jpeg "title")


## How They Work Together

When you create a custom 3D model for an item, you typically want to hide the default 2D sprite that Luanti would normally show. The **Item Profiles** mod makes this trivial with its built-in "invisible" profile.

You can also apply the invisible profile in bulk to entire mod namespaces or item categories:

```lua
-- Hide all default mod items that have custom models
item_profiles.apply_profile_bulk("^default:.*", "invisible")
```

## Documentation

For detailed API documentation, examples, and advanced usage:

- **Charged Models**: See `charged_models/README.md` for the complete animation API
- **Item Profiles**: See `item_profiles/README.md` for profile management documentation

Both mods include working examples in their respective folders.

## Use Cases

- **RPG Weapons**: Swords with slash animations, bows with draw mechanics, staffs with spell-casting motions
- **Enhanced Tools**: Pickaxes that swing, axes that chop, shovels that dig with realistic motion
- **Magic Systems**: Wands with charge-up effects, spell tomes with floating animations
- **Unique Items**: Torches with flickering flames, lanterns that sway, compasses that spin
- **Combat Systems**: Dual-wielding, charge attacks, combo chains, blocking animations

## Dependencies

None - this modpack is standalone and ready to use.

## Compatibility

Works with any Luanti game, including:
- Minetest Game
- MineClone2/5
- NodeCore
- And any other Luanti-based game

## License

- **Source Code**: MIT License
- **Media Assets**: CC0

## Credits

Created by **TomCon** for the Luanti community.