minetest.register_on_mods_loaded(function()
    
    -- Simple sword slash
    charged_models.create_animation("slash", {
        trigger = "press_dig",
        transform_keyframes = {
            {time = 0.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}},
            {time = 0.2, position = {x = 4, y = 14, z = 2}, rotation = {x = -45, y = 30, z = 0}, easing = "ease_out"},
            {time = 0.4, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in"}
        }
    })
    
    -- Block animation
    charged_models.create_animation("block", {
        trigger = "hold_place",
        hold_behavior = "hold_last_frame",
        transform_keyframes = {
            {time = 0.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}},
            {time = 0.3, position = {x = 2, y = 14, z = 2}, rotation = {x = -30, y = -45, z = 0}, easing = "ease_out"}
        }
    })
    
    -- Basic sword config
    charged_models.create_model_config("basic_sword", {
        mesh = "sword.gltf",
        textures = {"charged_models_cold.png"},
        scale = {x = 10, y = 10, z = 10},
        animations = {
            slash = "slash",
            block = "block"
        }
    })
    
    -- Dual wield config
    charged_models.create_model_config("dual_swords", {
        -- Left sword
        {
            mesh = "sword.gltf",
            textures = {"charged_models_cold.png"},
            position = {x = -2, y = 13, z = 3},
            scale = {x = 8, y = 8, z = 8},
            animations = {
                slash = {
                    trigger = "press_place",
                    transform_keyframes = {
                        {time = 0.0, position = {x = -2, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}},
                        {time = 0.2, position = {x = -3, y = 14, z = 2}, rotation = {x = -45, y = -30, z = 0}, easing = "ease_out"},
                        {time = 0.4, position = {x = -2, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in"}
                    }
                }
            }
        },
        -- Right sword
        {
            mesh = "sword.gltf",
            textures = {"charged_models_cold.png"},
            position = {x = 2, y = 13, z = 3},
            scale = {x = 8, y = 8, z = 8},
            animations = {
                slash = {
                    trigger = "press_dig",
                    transform_keyframes = {
                        {time = 0.0, position = {x = 5, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}},
                        {time = 0.2, position = {x = 6, y = 14, z = 2}, rotation = {x = -45, y = 30, z = 0}, easing = "ease_out"},
                        {time = 0.4, position = {x = 5, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in"}
                    }
                }
            }
        }
    })
    
charged_models.create_animation("idle_anim", {
    trigger = "none",  -- No trigger, plays automatically when idle
    keyframes = {start = 0, stop = 0},
    speed = 0,
    blend = 0,
    loop = true,  -- Loops continuously
    transform_keyframes = {
        {time = 0.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"},
        {time = 1.5, position = {x = 3, y = 13.2, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"},  -- Subtle rise
        {time = 3.0, position = {x = 3, y = 13, z = 3}, rotation = {x = 0, y = 0, z = 0}, easing = "ease_in_out"}   -- Return to base
    }
})
charged_models.create_model_config("idle", {
    mesh = "sword.gltf",
    textures = {"charged_models_cold.png"},
    animations = {
        idle = "idle_anim",  -- Reference the idle animation
        attack = "some_attack_anim"
    }
})

    -- Register items
    charged_models.register_item_model("default:sword_steel", "basic_sword")
    charged_models.register_item_model("charged_models:dual_swords", "dual_swords")
    
end)

-- Example tool registration
minetest.register_tool("charged_models:dual_swords", {
    description = "Dual Swords\nLeft click: right slash\nRight click: left slash",
    inventory_image = "charged_models_cold.png^charged_models_cold.png",
    tool_capabilities = {
        damage_groups = {fleshy = 6},
    },
})
