local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local S = minetest.get_translator(modname)

--mcl2 function
mcl_shovel_path_remove_function = {}

function mcl_shovel_path_remove_function.remove_dirtpath(itemstack, placer, pointed_thing)
	-- Use pointed node's on_rightclick function first, if present
	local node = minetest.get_node(pointed_thing.under)
	if placer and not placer:get_player_control().sneak then
		if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
			return minetest.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, placer, itemstack) or itemstack
		end
	end

	-- Only use grass path function if tool used on side or top of target node
	if pointed_thing.above.y < pointed_thing.under.y then
		return itemstack
	end

	if (minetest.get_item_group(node.name, "path_remove_possible") == 1) then
		local above = table.copy(pointed_thing.under)
		above.y = above.y + 1
		if minetest.get_node(above).name == "air" then
			if minetest.is_protected(pointed_thing.under, placer:get_player_name()) then
				minetest.record_protection_violation(pointed_thing.under, placer:get_player_name())
				return itemstack
			end

			if not minetest.is_creative_enabled(placer:get_player_name()) then
				-- Add wear (as if digging a shovely node)
				local toolname = itemstack:get_name()
				local wear = mcl_autogroup.get_wear(toolname, "shovely")
				if wear then
					itemstack:add_wear(wear)
				end
			end
			minetest.sound_play({name="default_grass_footstep", gain=1}, {pos = above}, true)
			minetest.swap_node(pointed_thing.under, {name="mcl_core:dirt"})
		end
	end
--regular path making logic
	if (minetest.get_item_group(node.name, "path_creation_possible") == 1) then
		local above = table.copy(pointed_thing.under)
		above.y = above.y + 1
		if minetest.get_node(above).name == "air" then
			if minetest.is_protected(pointed_thing.under, placer:get_player_name()) then
				minetest.record_protection_violation(pointed_thing.under, placer:get_player_name())
				return itemstack
			end

			if not minetest.is_creative_enabled(placer:get_player_name()) then
				-- Add wear (as if digging a shovely node)
				local toolname = itemstack:get_name()
				local wear = mcl_autogroup.get_wear(toolname, "shovely")
				if wear then
					itemstack:add_wear(wear)
				end
			end
			minetest.sound_play({name="default_grass_footstep", gain=1}, {pos = above}, true)
			minetest.swap_node(pointed_thing.under, {name="mcl_core:grass_path"})
		end
	end

	return itemstack
end

--overide grass path to include 'path_remove_possible=1' group
minetest.override_item("mcl_core:grass_path", {	groups = {handy=1, shovely=1, cultivatable=2, dirtifies_below_solid=1, dirtifier=1, deco_block=1, path_remove_possible=1, }, })

--function to determine whether game is mcl2 to apply overrides, these break mcla function logic
local mcl2test
	if (minetest.get_game_info().title == ("MineClone2") )then
--overide all shovels to use updated function
		minetest.override_item("mcl_tools:shovel_wood", { on_place  = mcl_shovel_path_remove_function.remove_dirtpath, })

		minetest.override_item("mcl_tools:shovel_stone", { on_place  = mcl_shovel_path_remove_function.remove_dirtpath, })

		minetest.override_item("mcl_tools:shovel_iron", { on_place  = mcl_shovel_path_remove_function.remove_dirtpath, })

		minetest.override_item("mcl_tools:shovel_diamond", { on_place  = mcl_shovel_path_remove_function.remove_dirtpath, })

		minetest.override_item("mcl_tools:shovel_gold", { on_place  = mcl_shovel_path_remove_function.remove_dirtpath, })

		minetest.override_item("mcl_tools:shovel_netherite", { on_place  = mcl_shovel_path_remove_function.remove_dirtpath, })
end

--mcla
mcla_shovel_path_remove_function = {}

function mcla_shovel_path_remove_function.remove_dirtpath(itemstack, placer, pointed_thing)
	-- Only remove grass path if tool used on side or top of target node
	if pointed_thing.above.y < pointed_thing.under.y then
		return itemstack
	end

	local above = table.copy(pointed_thing.under)
	above.y = above.y + 1
	if minetest.get_node(above).name == "air" then
		if not minetest.is_creative_enabled(placer:get_player_name()) then
			-- Add wear (as if digging a shovely node)
			local toolname = itemstack:get_name()
			local wear = mcl_autogroup.get_wear(toolname, "shovely")
			itemstack:add_wear(wear)
		end
		minetest.sound_play({name="default_grass_footstep", gain=1}, {pos = above}, true)
		minetest.swap_node(pointed_thing.under, {name="mcl_core:dirt"})
	end
	return itemstack,true
end
--overide grass path to use remove function instead
minetest.override_item("mcl_core:grass_path", {_on_shovel_place = mcla_shovel_path_remove_function.remove_dirtpath})

