local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local S = minetest.get_translator(modname)

--node registry

--Rose Gold Raw Ore Block
minetest.register_node("mcl_rose_gold:raw_rose_gold_ore_block", {
	description = S("Block of Raw Rose Gold"),
	_doc_items_longdesc = S("An congealed mass of raw rose gold"),
	tiles = {"mcl_rose_gold_raw_rose_gold_ore_block.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = { pickaxey = 2, building_block = 1, blast_furnace_smeltable = 1, oxidizable = 1 },
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
    _mcl_oxidized_variant = "mcl_rose_gold:raw_rose_gold_ore_block_exposed",
	_mcl_waxed_variant = "mcl_rose_gold:waxed_raw_rose_gold_ore_block",
})

--waxed raw block
minetest.register_node("mcl_rose_gold:waxed_raw_rose_gold_ore_block", {
	description = S("Waxed Raw Rose Gold Ore Block"),
	_doc_items_longdesc = S("A block of rose gold ore is mostly a decorative block."),
	tiles = {"mcl_rose_gold_raw_rose_gold_ore_block.png"},
	is_ground_content = false,
	groups = {pickaxey = 2, building_block = 1, waxed = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 3,
	_mcl_stripped_variant = "mcl_rose_gold:raw_rose_gold_ore_block",
})


--exposed rose gold raw ore block


minetest.register_node("mcl_rose_gold:raw_rose_gold_ore_block_exposed", {
	description = S("Exposed Rose Gold"),
	_doc_items_longdesc = S("Exposed Rose Gold is a decorative block."),
	tiles = {"mcl_rose_gold_raw_rose_gold_ore_block_exposed.png"},
	is_ground_content = false,
	groups = {pickaxey = 2, building_block = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
	_mcl_stripped_variant = "mcl_rose_gold:raw_rose_gold_ore_block",
	_mcl_waxed_variant = "mcl_rose_gold:waxed_raw_rose_gold_ore_block_exposed",
})

--waxed exposed block
minetest.register_node("mcl_rose_gold:waxed_raw_rose_gold_ore_block_exposed", {
	description = S("Waxed Exposed Raw Rose Gold Ore Block"),
	_doc_items_longdesc = S("A block of rose gold ore is mostly a decorative block."),
	tiles = {"mcl_copper_block.png"},
	is_ground_content = false,
	groups = {pickaxey = 2, building_block = 1, waxed = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 3,
	_mcl_stripped_variant = "mcl_rose_gold:raw_rose_gold_ore_block_exposed",
})

--Rose Gold Block
minetest.register_node("mcl_rose_gold:rose_gold_block", {
	description = S("Block of Rose Gold"),
	_doc_items_longdesc = S("A block of rose gold is mostly a shiny decorative block but also useful as a compact storage of rose gold ingots."),
	tiles = {"mcl_rose_gold_rose_gold_block.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey=4, building_block=1, oxidizable = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
    _mcl_oxidized_variant = "mcl_rose_gold:rose_gold_block_exposed",
    _mcl_waxed_variant = "mcl_rose_gold:waxed_rose_gold_block",

})
--Waxed Rose Gold Block
minetest.register_node("mcl_rose_gold:waxed_rose_gold_block", {
	description = S("Waxed Block of Rose Gold"),
	_doc_items_longdesc = S("A Waxed block of rose gold is mostly a shiny decorative block but also useful as a compact storage of rose gold ingots."),
	tiles = {"mcl_rose_gold_rose_gold_block.png"},
	is_ground_content = false,
	stack_max = 64,
	groups = {pickaxey=4, building_block=1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
	_mcl_stripped_variant = "mcl_rose_gold:rose_gold_block",
})
--Exposed Rose Gold Block
minetest.register_node("mcl_rose_gold:rose_gold_block_exposed", {
	description = S("Exposed Rose Gold"),
	_doc_items_longdesc = S("Exposed Rose Gold is a decorative block."),
	tiles = {"mcl_rose_gold_rose_gold_block_exposed.png"},
	is_ground_content = false,
	groups = {pickaxey = 2, building_block = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
	_mcl_stripped_variant = "mcl_rose_gold:rose_gold_block",
    _mcl_waxed_variant = "mcl_rose_gold:waxed_rose_gold_block_exposed",
})
--Waxed Exposed Rose Gold Block 
minetest.register_node("mcl_rose_gold:waxed_rose_gold_block_exposed", {
	description = S("Waxed Exposed Rose Gold"),
	_doc_items_longdesc = S("Waxed Exposed Rose Gold is a decorative block."),
	tiles = {"mcl_rose_gold_rose_gold_block_exposed.png"},
	is_ground_content = false,
	groups = {pickaxey = 2, building_block = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
})
--Rose Gold Lantern
mcl_lanterns.register_lantern("rose_gold_lantern", {
	description = S("Rose Gold Lantern"),
	longdesc = S("Rose gold lanterns are light sources which can be placed on the top or the bottom of most blocks."),
	texture = "mcl_rose_gold_rose_gold_lantern.png",
	texture_inv = "mcl_rose_gold_rose_gold_lantern_inv.png",
	light_level = 10,
})
--rose gold chain
minetest.register_node("mcl_rose_gold:rose_gold_chain", {
	description = S("Rose Gold Chain"),
	_doc_items_longdesc = S("Rose Gold Chains are metallic decoration blocks."),
	inventory_image = "mcl_rose_gold_rose_gold_chain_inv.png",
	tiles = {"mcl_rose_gold_rose_gold_chain.png"},
	drawtype = "mesh",
	paramtype = "light",
	paramtype2 = "facedir",
	use_texture_alpha = "clip",
	mesh = "mcl_lanterns_chain.obj",
	is_ground_content = false,
	sunlight_propagates = true,
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625},
		}
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625},
		}
	},
	groups = {pickaxey = 1, deco_block = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	on_place = function(itemstack, placer, pointed_thing)
		if pointed_thing.type ~= "node" then
			return itemstack
		end

		local p0 = pointed_thing.under
		local p1 = pointed_thing.above
		local param2 = 0

		local placer_pos = placer:get_pos()
		if placer_pos then
			local dir = {
				x = p1.x - placer_pos.x,
				y = p1.y - placer_pos.y,
				z = p1.z - placer_pos.z
			}
			param2 = minetest.dir_to_facedir(dir)
		end

		if p0.y - 1 == p1.y then
			param2 = 20
		elseif p0.x - 1 == p1.x then
			param2 = 16
		elseif p0.x + 1 == p1.x then
			param2 = 12
		elseif p0.z - 1 == p1.z then
			param2 = 8
		elseif p0.z + 1 == p1.z then
			param2 = 4
		end

		return minetest.item_place(itemstack, placer, pointed_thing, param2)
	end,
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
	mcl_lanterns.add_allowed_non_solid_nodes_ceiling("mcl_rose_gold:rose_gold_chain"),
	mcl_lanterns.add_allowed_non_solid_nodes_floor("mcl_rose_gold:rose_gold_chain"),
})
