local tnt_enabled = minetest.settings:get_bool("tnt_enabled", true)
local tnt_interval = tonumber(minetest.settings:get("interval")) or 3
local tnt_chance = tonumber(minetest.settings:get("chance")) or 100000
local minimum_spawn_height = tonumber(minetest.settings:get("minimum_spawn_height")) or -60
local maximum_spawn_height = tonumber(minetest.settings:get("maximum_spawn_height")) or 30927
local replacement_node = minetest.settings:get("replacement_node") or "none"
local node_interval = tonumber(minetest.settings:get("node_interval")) or 3
local node_chance = tonumber(minetest.settings:get("node_chance")) or 50000
local node_minimum_spawn_height = tonumber(minetest.settings:get("node_minimum_spawn_height")) or -60
local node_maximum_spawn_height = tonumber(minetest.settings:get("node_maximum_spawn_height")) or 30927

-- Go to these links for an explanation of what ABMs are:
-- https://rubenwardy.com/minetest_modding_book/en/map/timers.html
-- https://minetest.gitlab.io/minetest/definition-tables/#abm-activeblockmodifier-definition

-- For a list of all MineClone2 nodes and their names, go to the colors.txt file in the files for MineClone 2
-- It will probably be located at: Minetest 5.8\games\mineclone2\tools\colors.txt

if tnt_enabled then
    minetest.register_abm({
        label = "falling_tnt",
        nodenames = { "air" },
        interval = tnt_interval,
        chance = tnt_chance,
        min_y = minimum_spawn_height,
        max_y = maximum_spawn_height,
        action = function(pos)
            minetest.add_entity(pos, "mcl_tnt:tnt", nil)
        end
    })
end

-- "~="" means "not equal to"
if replacement_node ~= "none" then
    minetest.register_abm({
        label = "replace_node",
        nodenames = { "air" },
        interval = node_interval,
        chance = node_chance,
        min_y = node_minimum_spawn_height,
        max_y = node_maximum_spawn_height,
        action = function(pos)
            if replacement_node == "glowstone" then minetest.set_node(pos, { name = "mcl_nether:glowstone" })
            elseif replacement_node == "tnt" then minetest.set_node(pos, { name = "mcl_tnt:tnt" })
            elseif replacement_node == "monster_egg_stone" then minetest.set_node(pos, { name = "mcl_monster_eggs:monster_egg_stone" })
            elseif replacement_node == "fire" then minetest.set_node(pos, { name = "mcl_fire:fire" })
            elseif string.find(replacement_node, "spawner") then
                minetest.set_node(pos, { name = "mcl_mobspawners:spawner" })
                mcl_mobspawners.setup_spawner(pos, "mobs_mc:" .. string.sub(replacement_node, 9, -1))
            else minetest.set_node(pos, { name = "mcl_core:" .. replacement_node }) end
            -- Nodes that are part of the "mcl_core" mod do not need to be put here as they are accounted for in the above line of code
        end
    })
end





-- If you want more than one node to appear in the world, uncomment this code and replace the values with whatever you want
-- You can copy/paste this function call as many times as you want to add more ABMs
-- This code is non-functional because it is commented out. Uncomment it by removing the "--[[" or by adding a 3rd hyphen to it
--[[
minetest.register_abm({
    -- This variable determines what nodes will be replaced. It does not have to be just air.
    -- Try replacing it with "mcl_core:water_source", or try adding more nodes to the list separated with commas
    nodenames = { "air" },
    interval = 5,
    chance = 5000,
    min_y = -60, -- -60 is lower bound of MineClone2 worlds
    max_y = 30927, -- 30927 is upper bound of MineTest worlds
    action = function(pos) -- Replace the value below to change what node appears. Examples: "mcl_core:slimeblock" or "mcl_cake:cake"
        minetest.set_node(pos, { name = "mcl_core:ice" })
    end
})
--]]


-- Idea: Try modifying this code to make your own mod that causes the world to slowly turn into the nether
-- It could spawn fire in the air and slowly replace "mcl_core:dirt_with_grass" nodes with "mcl_nether:netherrack" or "mcl_nether:magma" nodes
-- And it could replace all water_source nodes with lava_source nodes