<!--
SPDX-FileCopyrightText: 2024 Tuxilio <mail@tuxil.io>

SPDX-License-Identifier: CC-BY-SA-4.0
-->

# Luanti MQTT Library

**A MQTT client library for Luanti**.

This is an alpha version, except bugs!

## Installation
Install [LuaRocks](https://luarocks.org/):

```bash
# On Debian:
apt install luarocks
```

Install `luasocket` & [`luamqtt`](https://github.com/xHasKx/luamqtt/)
```
luarocks install luasocket
luarocks install luamqtt
```

You have to add the mod to the trusted mods in [`minetest.conf`](https://wiki.luanti.org/Minetest.conf):

```
secure.trusted_mods = mqtt
```

## API docs

### `mqtt.connect`
**Function to create and connect an MQTT client**

- Parameters:
    - uri: The URI of the MQTT broker to connect to
    - client_id: A unique identifier for the MQTT client
    - username: The username for authentication (optional)
    - password: The password for authentication (optional)
- Returns:
    - client: The connected MQTT client instance. If the connection fails, it may return nil or an error message (depending on the implementation of mqtt.client)

```lua
local client = mqtt.connect(
    uri,
    clientId,
    username,
    password,
)
```

For example:

```lua
local client = mqtt.connect(
    uri = "mqtt.example.com",
    clientId = "lunanti",
    username = "user1",
    password = "password",
)
```

### `mqtt.publish`
**Function to publish a message to an MQTT broker**

- Parameters:
    - client: The MQTT client instance
    - topic: The topic to publish the message to
    - payload: The message payload to be published
    - options: A table containing optional parameters
        - qos: The QoS level for message publication (default is 1)
        - retain: A boolean flag indicating whether to retain the message (default is false)
        - dup: A boolean flag indicating whether the message is a duplicate (default is false)
        - properties: A table for additional properties for publishing the message (optional)
        - user_properties: A table for user-defined properties for publishing the message (optional)
        - callback: A function to call when the published message is acknowledged (optional)
- Returns:
    - success: true or packet id on success, or false and error message on failure

```lua
mqtt.publish(
    client,
    topic,
    payload,
    options,
)
```

Example:
```lua
mqtt.publish(
    client = client,
    topic = "test/topic",
    payload = "hello world!"
)
```
