-- Initialize the drying_rack table and its sub-tables
drying_rack = {}

local facedir = {}


-- Function to remove any existing item entity at a given position
drying_rack.remove_item_entity = function(pos)
    for _, obj in pairs(minetest.get_objects_inside_radius(pos, 0.5)) do
        if obj:get_luaentity() then
            obj:remove()
            minetest.log("action", "[drying_rack] Object removed")
        end
    end
end



drying_rack.update_item_entity = function(pos, node, param2)
    minetest.log("action", "[drying_rack] Updating item entity at position: " .. dump(pos))

    -- Remove any existing item entity
    drying_rack.remove_item_entity(pos)

    -- Get the metadata and inventory of the node
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    local item = inv:get_stack("main", 1)

    -- Exit if the inventory is empty
    if item:is_empty() then
        minetest.log("action", "[drying_rack] No item to display")
        return
    end

    -- Determine the facing direction of the node
    param2 = param2 or node.param2
    local pos_adj = facedir[param2] or { x = 0, y = 0, z = 0 }
    local yaw = math.pi * 2 - param2 * math.pi / 2


    minetest.log("action", "[drying_rack] pos_adjpos_adjpos_adjpos_adjpos_adjpos_adj position: " .. dump(pos_adj))

    -- Adjust the position of the item entity
    pos.x = pos.x + pos_adj.x * 6.5 / 16
    pos.y = pos.y + pos_adj.y * 6.5 / 16
    pos.z = pos.z + pos_adj.z * 6.5 / 16

    minetest.log("action", "[drying_rack] Modified position: " .. dump(pos))

    -- Create and configure the item entity
    local entity_name = node.name .. "_item"
    local entity = minetest.add_entity(pos, entity_name)
    if not entity then
        minetest.log("error", "[drying_rack] Failed to create entity")
        return
    end

    local lua_entity = entity:get_luaentity()
    if not lua_entity then
        minetest.log("error", "[drying_rack] Entity Lua object is nil")
        return
    end

    -- Set properties of the entity
    local item_name = item:get_name()
    lua_entity._nodename = node.name
    lua_entity._texture = item_name ~= "" and item_name or "blank.png"
    lua_entity._scale = (minetest.registered_items[item_name] and minetest.registered_items[item_name].wield_scale and minetest.registered_items[item_name].wield_scale.x) or
        1

    lua_entity:_update_texture()
    entity:set_yaw(yaw)

    minetest.log("action", "[drying_rack] Entity updated successfully")
end


function drying_rack.drop_generic_item(pos, node, meta, clicker)
    local name_found = false
    local found_name_to_use = ""
    local cname = ""

    if clicker and clicker:is_player() then
        cname = clicker:get_player_name()
    end
    if not minetest.is_creative_enabled(cname) then
        if (node.name == found_name_to_use) then
            local inv = meta:get_inventory()
            local item = inv:get_stack("main", 1)
            if not item:is_empty() then
                minetest.add_item(pos, item)
            end
        end
    end

    meta:set_string("infotext", "")
    drying_rack.remove_item_entity(pos, node)
end

function drying_rack.init(pos, node, meta, clicker)
    facedir[0] = { x = 0, y = 0, z = 1 }
    facedir[1] = { x = 1, y = 0, z = 0 }
    facedir[2] = { x = 0, y = 0, z = -1 }
    facedir[3] = { x = -1, y = 0, z = 0 }
end
