local VISUAL_SIZE = 0.3

minetest.register_node("drying_rack:drying_rack", {
    description = ("Drying Rack"),
    name = "drying_rack:drying_rack",
    _tt_help = "The Drying Rack is a block that is used to dry items.",
    drawtype = "mesh",
    is_ground_content = false,
    mesh = "drying_rack.obj",
    tiles = { "drying_rack.png" },
    selection_box = { type = "fixed", fixed = { 0.5, 0.43, 0.5, -0.5, 0.37, 0.18 } },
    collision_box = { type = "fixed", fixed = { 0.5, 0.43, 0.5, -0.5, 0.37, 0.18 } },
    use_texture_alpha = minetest.features.use_texture_alpha_string_modes and "opaque" or false,
    paramtype = "light",
    paramtype2 = "facedir",
    sunlight_propagates = true,
    groups = { dig_immediate = 3, deco_block = 1, dig_by_piston = 1, container = 1, supported_node_facedir = 1 },
    sounds = mcl_sounds.node_sound_defaults(),
    node_placement_prediction = "",
    -- Function to handle right-clicking the node
    on_rightclick = function(pos, node, clicker, itemstack)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        local item = inv:get_stack("main", 1)

        if not item:is_empty() then
            -- If there's already an item, give it to the player and remove it from the drying_rack
            local player_inv = clicker:get_inventory()
            if player_inv:room_for_item("main", item) then
                local put_itemstack = ItemStack(itemstack)
                local player_itemname = put_itemstack:get_name()
                if player_itemname == "mcl_mobitems:rotten_flesh" then
                    local itemname = item:get_name()
                    if itemname == "mcl_mobitems:rotten_flesh" then
                        return
                    end
                end

                player_inv:add_item("main", item)
                itemstack:add_item("main", item)
                inv:set_stack("main", 1, "")
                drying_rack.remove_item_entity(pos, node)
                meta:set_string("infotext", "")
                minetest.sound_play("default_place_node", { pos = pos, gain = 1.0 })

                -- Stop the timer if it's running
                local timer = minetest.get_node_timer(pos)
                if timer:is_started() then
                    timer:stop()
                end
            else
                minetest.chat_send_player(pname, "Your inventory is full!")
            end
            return
        end

        -- Otherwise, insert the item into the drying rack
        local put_itemstack = ItemStack(itemstack)
        put_itemstack:set_count(1)
        local itemname = put_itemstack:get_name()


        if itemname ~= "mcl_mobitems:rotten_flesh" then
            minetest.log("[drying_rack] Unsupported item: " .. itemname)
            return
        end

        if not minetest.is_creative_enabled(clicker:get_player_name()) then
            itemstack:take_item()
        end



        inv:set_stack("main", 1, put_itemstack)
        drying_rack.update_item_entity(pos, node)

        -- Start a timer for transformation
        local timer = minetest.get_node_timer(pos)
        timer:start(300.0) -- Start the timer for 3 seconds

        -- Add informational text to the node metadata if the item has a name
        local imeta = itemstack:get_meta()
        local iname = imeta:get_string("name")
        if iname then
            meta:set_string("infotext", iname)
        end

        return itemstack
    end,

    -- Function to handle the timer event
    on_timer = function(pos, elapsed)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        local item = inv:get_stack("main", 1)

        if not item:is_empty() and item:get_name() == "mcl_mobitems:rotten_flesh" then
            -- Transform the item into monster jerky
            local put_itemstack = ItemStack("drying_rack:monster_jerky")
            inv:set_stack("main", 1, put_itemstack)
            drying_rack.update_item_entity(pos, minetest.get_node(pos))
        end

        return false
    end,

    -- Function to handle node destruction
    on_destruct = function(pos)
        local meta = minetest.get_meta(pos)
        local node = minetest.get_node(pos)

        drying_rack.drop_generic_item(pos, node, meta)

        -- Stop the timer if it's running
        local timer = minetest.get_node_timer(pos)
        if timer:is_started() then
            timer:stop()
        end
        minetest.add_item(pos, "drying_rack:drying_rack")
    end,

    -- Function to handle node construction
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("main", 1)
    end,

    -- Functions to handle inventory operations
    allow_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
        local name = player:get_player_name()
        if minetest.is_protected(pos, name) then
            minetest.record_protection_violation(pos, name)
            return 0
        else
            return count
        end
    end,

    allow_metadata_inventory_take = function(pos, listname, index, stack, player)
        local name = player:get_player_name()
        if minetest.is_protected(pos, name) then
            minetest.record_protection_violation(pos, name)
            return 0
        else
            return stack:get_count()
        end
    end,

    allow_metadata_inventory_put = function(pos, listname, index, stack, player)
        local name = player:get_player_name()
        if minetest.is_protected(pos, name) then
            minetest.record_protection_violation(pos, name)
            return 0
        else
            return stack:get_count()
        end
    end,
})



minetest.register_entity("drying_rack:drying_rack_item", {
    hp_max = 1,
    visual = "wielditem",
    visual_size = { x = VISUAL_SIZE, y = VISUAL_SIZE },
    physical = false,
    pointable = false,
    textures = { "blank.png" },
    _texture = "blank.png",
    _scale = 1,
    groups = { immortal = 1 },

    -- Function to activate the entity
    on_activate = function(self, staticdata)
        if staticdata and staticdata ~= "" then
            local data = staticdata:split(";")
            self._nodename = data[1] or ""
            self._texture = data[2] or "blank.png"
            self._scale = tonumber(data[3]) or 1
        end

        self:_update_texture()
    end,

    -- Function to get static data for the entity
    get_staticdata = function(self)
        return table.concat({ self._nodename or "", self._texture or "", self._scale or 1 }, ";")
    end,

    -- Function to handle punching the entity
    on_punch = function() return true end,

    -- Function to update the texture of the entity
    _update_texture = function(self)
        if self._texture then
            self.object:set_properties({
                textures = { self._texture },
                visual_size = { x = VISUAL_SIZE / self._scale, y = VISUAL_SIZE / self._scale },
            })
        end
    end,
})
