local abs = math.abs

function respawn(player)
	if #rooms == 0 then
		minetest.after(1, respawn, player)
		return
	end
	local spawn_pos = rooms[1].pos
	player:set_pos(vector.add(spawn_pos, {x=6, y=4, z=6}))
end
minetest.register_on_joinplayer(respawn)
minetest.register_on_respawnplayer(respawn)

local tau = 2 * math.pi
local function yaw_from_dirs(dir, other_dir)
	return ({
		[NORTH]={[NORTH]=tau/2, [EAST]=tau/4, [SOUTH]=0, [WEST]=tau*3/4},
		[EAST] ={[NORTH]=tau*3/4, [EAST]=tau/2, [SOUTH]=tau/4, [WEST]=0},
		[SOUTH]={[NORTH]=0, [EAST]=tau*3/4, [SOUTH]=tau/2, [WEST]=tau/4},
		[WEST] ={[NORTH]=tau/4, [EAST]=0, [SOUTH]=tau*3/4, [WEST]=tau/2},
	})[dir][other_dir]
end

local player_room_indexes = {}
minetest.register_globalstep(function(dtime)
	for _, player in ipairs(minetest.get_connected_players()) do
		local name = player:get_player_name()
		local idx = player_room_indexes[name]
		if idx then
			local last_room = rooms[idx]
			local pos = player:get_pos()
			if not vector.equals(room_pos(pos), last_room.pos) then
				local vec = vector.subtract(pos, last_room:centroid())
				local dir = minetest.dir_to_wallmounted(vec)
				local neighbor = last_room.neighbors[dir]
				if (abs(vec.x+0.5) > 6.1 or abs(vec.z+0.5) > 6.1) and neighbor and neighbor.rotation then
					local room = rooms[neighbor.index]
					local map = get_rotation_map(dir, neighbor.rotation)
					local delta_yaw = yaw_from_dirs(dir, neighbor.rotation)
					local offset = map(vector.subtract(pos, room_pos(pos)))
					player:set_pos(vector.add(room.pos, offset))
					if delta_yaw > 0 then
						player:set_look_horizontal(player:get_look_horizontal() + delta_yaw)
					end
					player_room_indexes[name] = room.index
				end
			end
		else
			local pos = room_pos(player:get_pos())
			local index = pos_to_index(pos)
			local room = rooms[index]
			if room and vector.equals(room.pos, pos) then
				player_room_indexes[name] = index
			end
		end
	end
end)

local old_is_protected = minetest.is_protected
function minetest.is_protected(pos, name)
	pos = room_pos(pos)
	local index = pos_to_index(pos)
	local room = rooms[index]
	if name and not minetest.check_player_privs(name, "server") and not (room and vector.equals(room.pos, pos)) then
		return true
	end
	return old_is_protected(pos, name)
end
