
local content_ids
minetest.register_on_generated(
	function(minp, maxp, blockseed)
		if not content_ids then
			content_ids = {
				frame = minetest.get_content_id("rooms:frame"),
				barrier = minetest.get_content_id("rooms:barrier_gray"),
				air = minetest.get_content_id("rooms:air"),
				wall = minetest.get_content_id("rooms:wall"),
				grass = minetest.get_content_id("terrain:grass"),
			}
		end

		local vmanip, emin, emax = minetest.get_mapgen_object("voxelmanip")
		local buff = vmanip:get_data()
		local area = VoxelArea:new{MinEdge = emin, MaxEdge = emax}

		for i in area:iterp(minp, maxp) do
			local p = area:position(i)
			if (p.y + 1) % 12 <= 1 then
				local x = p.x % 12 - 5.5
				local z = p.z % 12 - 5.5
				local r = x*x + z*z
				if r < 6 then
					buff[i] = content_ids.barrier
				elseif r < 12 then
					buff[i] = content_ids.barrier
				else
					buff[i] = content_ids.wall
				end
			elseif (p.x + 1) % 12 <= 1 then
				local y = p.y % 12 - 5.5
				local z = p.z % 12 - 5.5
				local r = y*y + z*z
				if r < 6 then
					buff[i] = content_ids.barrier
				elseif r < 12 then
					buff[i] = content_ids.barrier
				else
					buff[i] = content_ids.wall
				end
			elseif (p.z + 1) % 12 <= 1 then
				local x = p.x % 12 - 5.5
				local y = p.y % 12 - 5.5
				local r = x*x + y*y
				if r < 6 then
					buff[i] = content_ids.barrier
				elseif r < 12 then
					buff[i] = content_ids.barrier
				else
					buff[i] = content_ids.wall
				end
			end
		end

		vmanip:set_data(buff)
		vmanip:write_to_map(true)
	end
)

function init_portals(world_pos)
	local openings = {}
	local frames = {}
	for u = 4,7 do
		for v = 3,8,5 do
			table.insert(frames, {x=0, y=v, z=u})
			table.insert(frames, {x=0, y=u, z=v})
			table.insert(frames, {x=11, y=v, z=u})
			table.insert(frames, {x=11, y=u, z=v})
			table.insert(frames, {x=u, y=v, z=0})
			table.insert(frames, {x=v, y=u, z=0})
			table.insert(frames, {x=u, y=v, z=11})
			table.insert(frames, {x=v, y=u, z=11})
		end
	--end
	--for u = 4,7 do
		for v = 4,7 do
			table.insert(openings, {x=0, y=u, z=v})
			table.insert(openings, {x=11, y=u, z=v})
			table.insert(openings, {x=u, y=v, z=0})
			table.insert(openings, {x=u, y=v, z=11})
		end
	end
	for i, v in ipairs(openings) do
		openings[i] = vector.add(world_pos, v)
	end
	for i, v in ipairs(frames) do
		frames[i] = vector.add(world_pos, v)
	end
	minetest.bulk_set_node(openings, {name="rooms:air"})
	minetest.bulk_set_node(frames, {name="rooms:frame"})
end

function generate_spawn_room(world_pos)
	local node = minetest.get_node_or_nil(world_pos)
	if not node then
		minetest.emerge_area(
			world_pos,
			vector.add(world_pos, 12),
			function (blockpos, action, calls_remaining, param)
				if calls_remaining ~= 0 then
					return
				end
				generate_spawn_room(world_pos)
			end
		)
		return
	end
	local nodes = {}
	for x = 1,10 do for y = 1,2 do for z = 1,10 do
		table.insert(nodes, vector.add(world_pos,{x=x,y=y,z=z}))
	end end end
	minetest.bulk_set_node(nodes, {name="terrain:dirt"})
	nodes = {}
	for x = 1,10 do for z = 1,10 do
		table.insert(nodes, vector.add(world_pos,{x=x,y=3,z=z}))
	end end
	minetest.bulk_set_node(nodes, {name="terrain:grass"})
	init_portals(world_pos)
end

function generate_schematic(world_pos, schematic)
	local node = minetest.get_node_or_nil(world_pos)
	if not node then
		minetest.emerge_area(
			world_pos,
			vector.add(world_pos, 12),
			function (blockpos, action, calls_remaining, param)
				if calls_remaining ~= 0 then
					return
				end
				generate_schematic(world_pos, schematic)
			end
		)
		return
	end
	local vmanip = minetest.get_voxel_manip(world_pos, vector.add(world_pos, 12))
	minetest.place_schematic_on_vmanip(vmanip, world_pos, schematic) --, rotation, replacements, force_placement, flags)`
	vmanip:write_to_map(false)
end

local prefix = minetest.get_modpath(minetest.get_current_modname()) .. "/schems/"
minetest.after(0, function()
	rooms:load()
	if #rooms == 0 then
		print("No rooms. Generating them")
		minetest.after(0, function()
			for i, schem in ipairs{
				"spawn.mts",
				"bridge.mts",
				"forest.mts",
				"library.mts",
				"mine.mts",
				"room1.mts",
				"room2.mts",
				"shelf.mts",
				"tree.mts",
			} do
				local room = Room.allocate_new()
				generate_schematic(room.pos, prefix .. schem)
				for _, dir in ipairs{NORTH, EAST, SOUTH, WEST} do
					room:portal_modified(dir)
				end
			end
		end)
	end
end)
