local world_path = minetest.get_worldpath()
local save_rooms = world_path .. "/rooms.txt"
--local save_portals = world_path .. "/portals.txt"

function rooms:save()
	local data = {}
	local output = io.open(save_rooms, "w")
	for i, room in ipairs(self) do
		local n = room.neighbors
		table.insert(data, string.format(
			"%d %d %d %d",
			n[NORTH] and n[NORTH].index or 0,
			n[EAST]  and n[EAST] .index or 0,
			n[SOUTH] and n[SOUTH].index or 0,
			n[WEST]  and n[WEST] .index or 0
		))
	end
	output:write(table.concat(data, "\n"))
	io.close(output)
end

function rooms:load()
	assert(#portals == 0)
	local input = io.open(save_rooms, "r")
	if not input then return end
	--local i = 1
	while true do
		local n, e, s, w = input:read("*n", "*n", "*n", "*n")
		if not n then break end
		local room = Room.allocate_new()
		--room.neighbors = {}
		--if n ~= 0 then room.neighbors[NORTH] = { index = n } end
		--if e ~= 0 then room.neighbors[EAST]  = { index = e } end
		--if s ~= 0 then room.neighbors[SOUTH] = { index = s } end
		--if w ~= 0 then room.neighbors[WEST]  = { index = w } end
		for _, dir in pairs{NORTH, EAST, SOUTH, WEST} do
			room:portal_modified(dir)
		end

		--self[i] = room
		--i = i + 1
	end
	-- for index, room in ipairs(self) do
	-- 	--for dir, neighbor in pairs(room.neighbors) do
	-- 	for _, dir in pairs{NORTH, EAST, SOUTH, WEST} do
	-- 		room:portal_modified(dir)
	-- 	end
	-- end
	print("Loaded: " .. dump(rooms))
	print("Portals: " .. dump(portals))
end
