
for i = 1, 8 do
	local height = i * 0.125 - 0.5
	local selection_height = i * 0.0625 - 0.5
	minetest.register_node("farming:wheat"..i, {
		description = "Wheat",
		drawtype = "nodebox",
		tiles = {
			"wheat_top.png^[verticalframe:8:"..(i-1),
			"wheat_top.png^[verticalframe:8:"..(i-1),
			"wheat_sides.png^[transform4^[verticalframe:8:"..(i-1),
			"wheat_sides.png^[transform4^[verticalframe:8:"..(i-1),
			"wheat_sides.png^[verticalframe:8:"..(i-1),
			"wheat_sides.png^[verticalframe:8:"..(i-1),
		},
		walkable = false,
		pointable = true,
		diggable = true,
		groups = { wheat = 1, oddly_breakable_by_hand = 1, attached_node = 1},
		paramtype = "light",
		connects_to = {"group:wheat"},
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, selection_height, 0.5},
		},
		node_box = {
			type = "connected",
			fixed = {
				{ -0.375, -0.5, -0.125, -0.125, height, 0.125 },
				{ -0.125, -0.5, -0.375, 0.125, height, -0.125 },
				{ 0.125, -0.5, -0.125, 0.375, height, 0.125 },
				{ -0.125, -0.5, 0.125, 0.125, height, 0.375 },
			},
			connect_right = {
				--{ 0.375, -0.5, 0.125, 0.625, height, 0.375 },
				{ 0.375, -0.5, -0.375, 0.625, height, -0.125 },
			},
			connect_left = {
				--{ -0.625, -0.5, -0.375, -0.375, height, -0.125 },
				{ -0.625, -0.5, 0.125, -0.375, height, 0.375 },
			},
			connect_front = {
				{ -0.375, -0.5, -0.625, -0.125, height, -0.375 },
				--{ 0.125, -0.5, -0.625, 0.375, height, -0.375 },
			},
			connect_back = {
				{ 0.125, -0.5, 0.375, 0.375, height, 0.625 },
				--{ -0.375, -0.5, 0.375, -0.125, height, 0.625 },
			},
		},
	})
end

minetest.register_node("farming:soil", {
	description = "Soil",
	tiles = { "soil.png", "dirt.png" },
	walkable = true,
	pointable = true,
	diggable = true,
	groups = { oddly_breakable_by_hand = 1 },
	drop = "terrain:grass",
})

