
minetest.register_node("terrain:grass", {
	description = "Grass",
	tiles = { "grass.png", "dirt.png", "dirt.png^grass_sides.png", },
	walkable = true,
	pointable = true,
	diggable = true,
	groups = { oddly_breakable_by_hand = 1 },
	on_place = function(itemstack, placer, pointed_thing)
		if pointed_thing.type == "node" then
			local pos = pointed_thing.under
			local node = minetest.get_node(pos)
			if node.name == "rooms:frame" then
				local topnode = minetest.get_node{x=pos.x, y=pos.y+1, z=pos.z}
				if not is_airy(topnode.name) then
					itemstack:set_name("terrain:dirt")
					local r, p = minetest.item_place(itemstack, placer, pointed_thing)
					r:set_name("terrain:grass")
					return r, p
				end
				local botnode = minetest.get_node{x=pos.x, y=pos.y-1, z=pos.z}
			end
		end
		return minetest.item_place(itemstack, placer, pointed_thing)
	end,
})

minetest.register_node("terrain:dirt", {
	description = "Dirt",
	tiles = { "dirt.png" },
	walkable = true,
	pointable = true,
	diggable = true,
	groups = { oddly_breakable_by_hand = 1 },
	drop = "terrain:grass",
})

minetest.register_node("terrain:stone_ruby", {
	description = "Stone with Ruby",
	tiles = { "stone_ruby.png" },
	walkable = true,
	pointable = true,
	diggable = true,
	groups = { oddly_breakable_by_hand = 1 },
})

minetest.register_node("terrain:stone_emerald", {
	description = "Stone with Emerald",
	tiles = { "stone_emerald.png" },
	walkable = true,
	pointable = true,
	diggable = true,
	groups = { oddly_breakable_by_hand = 1 },
})

minetest.register_node("terrain:stone_sapphire", {
	description = "Stone with Sapphire",
	tiles = { "stone_sapphire.png" },
	walkable = true,
	pointable = true,
	diggable = true,
	groups = { oddly_breakable_by_hand = 1 },
})

minetest.register_node("terrain:stone", {
	description = "Stone",
	tiles = { "stone.png" },
	walkable = true,
	pointable = true,
	diggable = true,
	groups = { oddly_breakable_by_hand = 1 },
})

function is_airy(node_name)
	return node_name == "air" or minetest.registered_nodes[node_name].paramtype == "light"
end

minetest.register_on_placenode(function(pos, newnode, placer, oldnode, itemstack, pointed_thing)
	local b_pos = {x=pos.x, y=pos.y-1, z=pos.z}
	local botnode_name = minetest.get_node(b_pos).name
	if is_airy(newnode.name) then
		if botnode_name == "terrain:dirt" then
			minetest.swap_node(b_pos, {name = "air"})
			minetest.place_node(b_pos, {name = "terrain:grass"})
		end
	else
		local topnode = minetest.get_node{x=pos.x, y=pos.y+1, z=pos.z}
		if is_airy(topnode.name) then
			if newnode.name == "terrain:dirt" then
				minetest.swap_node(pos, {name = "air"})
				minetest.place_node(pos, {name = "terrain:grass"})
			end
		else
			if newnode.name == "terrain:grass" then
				minetest.swap_node(pos, {name = "air"})
				minetest.place_node(pos, {name = "terrain:dirt"})
			end
		end
		if botnode_name == "terrain:grass" then
			minetest.swap_node(b_pos, {name = "air"})
			minetest.place_node(b_pos, {name = "terrain:dirt"})
		end
	end
end)

minetest.register_on_dignode(function(pos, oldnode, digger)
	local b_pos = {x=pos.x, y=pos.y-1, z=pos.z}
	local botnode_name = minetest.get_node(b_pos).name
	if botnode_name == "terrain:dirt" then
		minetest.swap_node(b_pos, {name = "air"})
		minetest.place_node(b_pos, {name = "terrain:grass"})
	end
end)


