
minetest.register_craftitem("book:book", {
	description = "Book",
	short_description = "Book",
	inventory_image = "book.png",
	--groups = { oddly_breakable_by_hand = 1 },
	on_place = function(itemstack, placer, pointed_thing)
		local under = pointed_thing.under
		local node = minetest.get_node(under)
		if node.name == "wood:shelf" then
			local item = itemstack:take_item()
			if item and not minetest.is_protected(under, "") then
				minetest.set_node(under, {name = "air"})
				minetest.place_node(under, {name = "book:bookshelf"})
				return itemstack
			end
		end
	end,
})

minetest.register_node("book:bookshelf", {
	description = "Bookshelf",
	tiles = { "wood.png", "wood.png", "bookshelf.png" },
	walkable = true,
	pointable = true,
	diggable = true,
	groups = {},
	on_punch = function(pos, node, puncher, pointed_thing)
		if not minetest.is_protected(pos, puncher:get_player_name()) then
			local inv = puncher:get_inventory()
			local stack = ItemStack("book:book")
			local x = inv:add_item("main", stack)
			if x:is_empty() then
				minetest.set_node(pos, {name = "air"})
				minetest.place_node(pos, {name = "wood:shelf"})
			end
		end
	end,
})

