

-- Barriers
-- Red: bad portal
-- Pink: Unfilled frames
-- Blue: Unconnected
-- Gray: Fake portal

minetest.register_node("rooms:barrier_pink", {
	description = "Barrier",
	drawtype = "allfaces_optional",
	waving = 2,
	light_source = 1,
	paramtype = "light",
	tiles = {name = "barrier_pink.png"},
	--walkable = false,
	diggable = false,
})

minetest.register_node("rooms:barrier_red", {
	description = "Barrier",
	drawtype = "allfaces_optional",
	waving = 2,
	light_source = 1,
	paramtype = "light",
	tiles = {name = "barrier_red.png"},
	--walkable = false,
	diggable = false,
})

minetest.register_node("rooms:barrier_gray", {
	description = "Barrier",
	drawtype = "allfaces_optional",
	waving = 2,
	light_source = 1,
	paramtype = "light",
	tiles = {name = "barrier_gray.png"},
	--walkable = false,
	diggable = false,
})

minetest.register_node("rooms:barrier", {
	description = "Barrier",
	drawtype = "allfaces_optional",
	waving = 2,
	light_source = 1,
	paramtype = "light",
	tiles = {name = "barrier.png"},
	--walkable = false,
	diggable = false,
})

minetest.register_node("rooms:air", {
	description = "Portal Air",
	drawtype = "airlike",
	--drawtype = "allfaces_optional",
	--tiles = {"leaves.png"},
	paramtype = "light",
	walkable = false,
	pointable = false,
	sunlight_propagates = true,
})

minetest.register_node("rooms:wall", {
	description = "Wall",
	tiles = {"wall.png"},
	--drawtype = "allfaces_optional",
	--use_texture_alpha = "blend",
})

function portal_frame_replaced(world_pos)
	local room = rooms[pos_to_index(room_pos(world_pos))]
	if room then
		local dir = room:portal_frame_dir(world_pos)
		if dir then
			room:portal_modified(dir)
		end
	else
		print("No room at " .. (minetest.pos_to_string(world_pos)))
		--print("Rooms: " .. dump(rooms))
	end
end

minetest.register_node("rooms:frame", {
	description = "Frame",
	--paramtype = "light",
	light_source = 8,
	drawtype = "allfaces",
	use_texture_alpha = "blend",
	tiles = {"frame.png"},
	buildable_to = true,
	after_destruct = portal_frame_replaced,
})

minetest.register_on_dignode(function(world_pos, oldnode, digger)
	local the_room_pos = room_pos(world_pos)
	local room = rooms[pos_to_index(the_room_pos)]
	if room and vector.equals(room.pos, the_room_pos) then
		local dir = room:portal_frame_dir(world_pos)
		if dir then
			room:fill_frames(dir)
			-- ^ should automatically trigger v
			--room:portal_modified(dir)
		end
		room:update_mirrors(world_pos)
	end
end)

minetest.register_on_placenode(function(world_pos, newnode, placer, oldnode, itemstack, pointed_thing)
	local the_room_pos = room_pos(world_pos)
	local room = rooms[pos_to_index(the_room_pos)]
	if room and vector.equals(room.pos, the_room_pos) then
		room:update_mirrors(world_pos)
	end
end)

