minetest.register_tool("healing_stick:healing_stick", {
    description = ("Healing Stick"),
    inventory_image = "healing_stick.png",
    tool_capabilities = {
        full_punch_interval = 1,
        max_drop_level = 0,
        groupcaps = {
            snappy = {times = {[2] = 1.6, [3] = 0.40}, uses = 10, maxlevel = 1},
        },
        damage_groups = {fleshy = 0},  -- Урон 0, чтобы не было отбрасывания
    },
    sound = {breaks = "default_tool_breaks"},
    groups = {sword = 1, flammable = 2},
    
    -- Обработчик при использовании (правый клик)
    on_use = function(itemstack, user, pointed_thing)
        -- Если кликнули на объект (игрок или моб)
        if pointed_thing.type == "object" then
            local target = pointed_thing.ref
            
            -- Проверяем, живой ли объект
            if target then
                local healed = false
                local target_pos
                
                -- Для игроков
                if target:is_player() then
                    local hp = target:get_hp()
                    local max_hp = target:get_properties().hp_max or 2000 -- тут макс здоровье для игроков
                    
                    if hp < max_hp then
                        local new_hp = math.min(hp + 5, max_hp) -- тут плюс здоровье для игроков
                        target:set_hp(new_hp)
                        healed = true
                        target_pos = target:get_pos()
                    end
                    
                -- Для мобов (Lua entities)
                else
                    local entity = target:get_luaentity()
                    if entity then
                        target_pos = target:get_pos()
                        
                        -- Для мобов из mobs_redo
                        if entity.health then
                            local max_hp = entity.health_max or 2000  -- тут макс здоровье для мобов
                            if entity.health < max_hp then
                                entity.health = math.min(entity.health + 5, max_hp) -- тут плюс здоровье для мобов
                                healed = true
                                
                                -- Обновление здоровья для mobs_redo
                                if entity.set_health then
                                    entity:set_health(entity.health)
                                end
                            end
                        
                        -- Для мобов из других модов (используют стандартные методы)
                        elseif target.get_hp and target.set_hp then
                            local hp = target:get_hp()
                            local max_hp = 20
                            
                            -- Пытаемся получить максимальное здоровье из свойств
                            local properties = target:get_properties()
                            if properties and properties.hp_max then
                                max_hp = properties.hp_max
                            end
                            
                            if hp < max_hp then
                                local new_hp = math.min(hp + 5, max_hp)
                                target:set_hp(new_hp)
                                healed = true
                            end
                        end
                    end
                end
                
                -- Если кого-то вылечили
                if healed then
                    -- Эффект частиц
                    if target_pos then
                        minetest.add_particlespawner({
                            amount = 15,
                            time = 0.5,
                            minpos = {x = target_pos.x - 0.3, y = target_pos.y + 0.1, z = target_pos.z - 0.3},
                            maxpos = {x = target_pos.x + 0.3, y = target_pos.y + 1.5, z = target_pos.z + 0.3},
                            minvel = {x = -0.5, y = 0.5, z = -0.5},
                            maxvel = {x = 0.5, y = 1.5, z = 0.5},
                            minacc = {x = 0, y = -2, z = 0},
                            maxacc = {x = 0, y = -5, z = 0},
                            minexptime = 0.5,
                            maxexptime = 1.5,
                            minsize = 0.5,
                            maxsize = 1.2,
                            collisiondetection = false,
                            texture = "heart.png",  -- Нужна текстура сердца
                            glow = 10
                        })
                    end
                    
                    -- Износ инструмента
                    itemstack:add_wear(65535/10)  -- 10 использований
                    
                    -- Звук лечения
                    minetest.sound_play("default_place_node_hard", {
                        pos = target_pos or user:get_pos(),
                        gain = 0.5,
                        max_hear_distance = 8
                    })
                    
                    -- Если лечим себя, добавим сообщение
                    if user:get_player_name() == target:get_player_name() then
                        minetest.chat_send_player(user:get_player_name(), "Вы исцелили себя на 5 HP!")
                    end
                end
            end
        end
        return itemstack
    end,
})
