armor:register_armor(":skates:skates", {
		description = ("Skates"),
		inventory_image = "3d_armor_inv_skates_steel.png",
		groups = {armor_feet=1, armor_heal=0, armor_use=800,
			physics_speed=-0.01, physics_gravity=0.01},
		armor_groups = {fleshy=10},
		damage_groups = {cracky=2, snappy=3, choppy=2, crumbly=1, level=2},
	})


minetest.register_craft({
    output = "skates:skates",
    recipe = {
        {"default:leaves", "default:leaves", "default:leaves"},
        {"default:leaves", "default:leaves", "default:leaves"},
        {"default:leaves", "default:leaves", ""},
    }
})

local ice_players = {}
local timer = 0


local function check_ice_conditions(player)
    local name = player:get_player_name()
    

    local has_steel_boots = false
    local _, armor_inv = armor:get_valid_player(player)
    
    if armor_inv then
        for i = 1, armor_inv:get_size("armor") do
            local stack = armor_inv:get_stack("armor", i)
            if stack:get_name() == "skates:skates" then
                has_steel_boots = true
                break
            end
        end
    end


    local pos = player:get_pos()
    local pos_under = {x = pos.x, y = pos.y - 0.1, z = pos.z}
    local node_under = minetest.get_node(pos_under).name
    
    local is_on_ice = (node_under == "default:ice" or node_under == "default:cave_ice")
    
    return has_steel_boots and is_on_ice
end

-- ice phisics
local function apply_ice_physics(player)
    player:set_physics_override({
        speed = 2,
        jump = 1.0,
        gravity = 1.0,
        acceleration_default = 0.1, 
        acceleration_air = 0.1,
        friction = 1, 
        slippery = 1,
    })
end

-- start
local function apply_starting_physics(player)
    player:set_physics_override({
        speed = 2.1, 
        jump = 1, 
        gravity = 1.0,
        acceleration_default = 1, 
        acceleration_air = 1,
        friction = 1, 
        slippery = 1, 
    })
end

-- normal
local function reset_physics(player)
    player:set_physics_override({
        speed = 1.0,
        jump = 1.0,
        gravity = 1.0,
        acceleration_default = 1.0,
        acceleration_air = 1.0,
        friction = 1.0, 
        slippery = 1.0,
    })
end


minetest.register_globalstep(function(dtime)
    timer = timer + dtime
    
    if timer >= 0.1 then
        timer = 0
        
        for _, player in ipairs(minetest.get_connected_players()) do
            local name = player:get_player_name()
            
           
            if not ice_players[name] then
                ice_players[name] = {
                    on_ice = false,
                    state = "normal", 
                    movement_cooldown = 0,
                    was_moving = false,
                    starting_timer = 0
                }
            end
            
            local state = ice_players[name]
            local is_on_ice_now = check_ice_conditions(player)
            local controls = player:get_player_control()
            local is_moving_now = controls.up or controls.down or controls.left or controls.right
            
            
            if state.state == "starting" then
                state.starting_timer = state.starting_timer - 0.1
                if state.starting_timer <= 0 then
                    state.state = "sliding"
                    state.starting_timer = 0
                    if is_on_ice_now then
                        apply_ice_physics(player)
                        minetest.chat_send_player(name, "yes (скольжение)")
                    end
                end
            end
            
           
            local movement_started = not state.was_moving and is_moving_now
            local movement_stopped = state.was_moving and not is_moving_now
            
            
            if movement_started and is_on_ice_now and state.state ~= "starting" then
                state.state = "starting"
                state.starting_timer = 1 
                apply_starting_physics(player)
                minetest.chat_send_player(name, "starting (начало движения)")
            end
            
           
            if movement_stopped and is_on_ice_now and state.state ~= "sliding" then
                state.state = "sliding"
                state.starting_timer = 0
                apply_ice_physics(player)
                minetest.chat_send_player(name, "yes (скольжение)")
            end
            
          
            if not is_on_ice_now and state.state ~= "normal" then
                state.state = "normal"
                reset_physics(player)
                minetest.chat_send_player(name, "no")
            end
            
           
            if is_on_ice_now and state.state == "normal" and not is_moving_now then
                state.state = "sliding"
                apply_ice_physics(player)
                minetest.chat_send_player(name, "yes (скольжение)")
            end
            
        
            state.was_moving = is_moving_now
            state.on_ice = is_on_ice_now
        end
    end
    
   
    for _, player in ipairs(minetest.get_connected_players()) do
        local name = player:get_player_name()
        local state = ice_players[name]
        
        if state and state.state == "sliding" then
            local vel = player:get_velocity()
            local horizontal_speed = math.sqrt(vel.x^2 + vel.z^2)
            
            if horizontal_speed > 0.5 then
                local look_dir = player:get_look_dir()
                local look_h = {x = look_dir.x, z = look_dir.z}
                local length = math.sqrt(look_h.x^2 + look_h.z^2)
                
                if length > 0 then
                    look_h.x = look_h.x / length
                    look_h.z = look_h.z / length
                    
                    local turn_smoothness = 2.0 * dtime
                    local new_vx = vel.x + (look_h.x * horizontal_speed - vel.x) * turn_smoothness
                    local new_vz = vel.z + (look_h.z * horizontal_speed - vel.z) * turn_smoothness
                    
                    player:add_velocity({
                        x = new_vx - vel.x,
                        y = 0,
                        z = new_vz - vel.z
                    })
                end
            end
        end
    end
end)


minetest.register_on_joinplayer(function(player)
    reset_physics(player)
    local name = player:get_player_name()
    ice_players[name] = {
        on_ice = false,
        state = "normal",
        movement_cooldown = 0,
        was_moving = false,
        starting_timer = 0
    }
end)

minetest.register_on_respawnplayer(function(player)
    reset_physics(player)
    local name = player:get_player_name()
    ice_players[name] = {
        on_ice = false,
        state = "normal",
        movement_cooldown = 0,
        was_moving = false,
        starting_timer = 0
    }
end)


minetest.register_on_leaveplayer(function(player)
    ice_players[player:get_player_name()] = nil
end)
