local S, PS = core.get_translator("ok_bloomer")

local parse_value = function(raw)
    if raw == nil then
        return nil
    end
    local number = tonumber(string.sub(raw, 5))
    if number == nil then
        return nil
    end
    return number / 1000
end

core.register_chatcommand("ok_bloomer", {
    description = S("Open the Bloom Configuration Menu"),
    func = function(name)
        local player = core.get_player_by_name(name)
        if player == nil then
            return
        end
        local bloom = player:get_lighting().bloom
        local formspec = string.format(
            [[
            formspec_version[10]
            size[8,5]
            label[1,1;%s]
            scrollbar[1,1.25;6,0.5;horizontal;bloom_intensity;%d]
            label[1,2;%s]
            scrollbaroptions[max=10000]
            scrollbar[1,2.25;6,0.5;horizontal;bloom_strength_factor;%d]
            label[1,3;%s]
            scrollbaroptions[max=8000]
            scrollbar[1,3.25;6,0.5;horizontal;bloom_radius;%d]
        ]],
            S("Intensity"),
            bloom.intensity * 1000,
            S("Strength"),
            bloom.strength_factor * 1000,
            S("Radius"),
            bloom.radius * 1000
        )
        core.show_formspec(name, "ok_bloomer:config", formspec)
    end
})

core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "ok_bloomer:config" then
        return
    end

    local lighting = player:get_lighting()

    local intensity = parse_value(fields.bloom_intensity)
    local strength_factor = parse_value(fields.bloom_strength_factor)
    local radius = parse_value(fields.bloom_radius)

    player:set_lighting({
        bloom = {
            intensity = intensity,
            strength_factor = strength_factor,
            radius = radius,
        }
    })

    local meta = player:get_meta()
    if intensity then
        meta:set_float("ok_bloomer:intensity", intensity)
    end
    if strength_factor then
        meta:set_float("ok_bloomer:strength_factor", strength_factor)
    end
    if radius then
        meta:set_float("ok_bloomer:radius", radius)
    end
end)

core.register_on_joinplayer(function(player)
    local meta = player:get_meta()
    player:set_lighting({
        bloom = {
            intensity = meta:get_float("ok_bloomer:intensity"),
            strength_factor = meta:get_float("ok_bloomer:strength_factor"),
            radius = meta:get_float("ok_bloomer:radius"),
        }
    })
end)
