ham_radio_api = {}
ham_radio_api.frequency = {}

ham_radio_api.settings = {
    server = tostring(core.settings:get("ham_radio_api.server") or "http://apocalypse.texnoblog.uz"),
    send_interval = tonumber(core.settings:get("ham_radio_api.send_interval")) or 10,
    get_interval = tonumber(core.settings:get("ham_radio_api.get_interval")) or 5,
    
    -- interserver frequencies
    api_frequency = {
        min = tonumber(core.settings:get("ham_radio_api.min_frequency")) or ham_radio.settings.frequency.min,
        max = tonumber(core.settings:get("ham_radio_api.max_frequency")) or ham_radio.settings.frequency.max
    }
}
local http = core.request_http_api()
local S = minetest.get_translator("ham_radio_api")

local function urlencode(str)
    if str == nil then return "" end
    str = string.gsub(str, "([^%w _%%%-%.~])", function(c)
        return string.format("%%%02X", string.byte(c))
    end)
    return string.gsub(str, " ", "+")
end

local function http_request(url, callback)
    http.fetch({
        url = url,
        method = "GET",
        extra_headers = {
            "User-Agent: Minetest-HamRadio/1.0",
            "Content-Type: application/json",
        }
    }, callback or function() end)
end

local function sendToApi(frequency, msg)
    for i, v in ipairs(msg) do
        core.after(i * 20, function()  -- задержка 1.5 сек между сообщениями
            http_request(
            ham_radio_api.settings.server ..
                "/api/hamRadio/set/?frequency=" .. frequency ..
                "&text=" .. urlencode(v)
            )
        end)
    end
end

local function getApi(frequency)
    http_request(
            ham_radio_api.settings.server ..
                    "/api/hamRadio/get/?frequency=" .. frequency,
            function(res)
                if res.succeeded then
                    local data = core.parse_json(res.data)
                    if data and data.status == "ok" then
                        ham_radio_api.frequency[tonumber(data.frequency)] = data.text
                    end
                else
                    core.log("error", "[ham_radio_api] Failed to get RDS messages")
                end
            end
    )
end

local function checkRange(frequency_str)
    if frequency_str == "" then
        return false
    end
    local frequency = tonumber(frequency_str)
    if frequency < ham_radio_api.settings.api_frequency.min then
        return false
    end
    if frequency > ham_radio_api.settings.api_frequency.max then
        return false
    end
    return true
end

local function handheldReceiver(player)
    local item = player:get_wielded_item()

    if item:get_name() ~= "ham_radio:handheld_receiver" then
        return
    end

    local meta = item:get_meta()
    local frequency = meta:get_string("frequency")
    local rds_disabled = meta:get_string("rds_disabled")

    if checkRange(frequency) == false then
        return
    end

    if rds_disabled == "true" then
        -- disabled receiving RDS messages
        return
    end
    getApi(frequency)
    local text = ham_radio_api.frequency[tonumber(frequency)]
    if text then
        core.chat_send_player(player:get_player_name(), S('Global frequency @1', core.colorize(ham_radio.settings.rds_color, text)))
    end
end

local timer = 0
core.register_globalstep(function(dtime)
    timer = timer + dtime

    if timer > 6 then
        local players = core.get_connected_players()
        for _, player in ipairs(players) do
            handheldReceiver(player)
        end
        timer = 0
    end
end)

core.register_abm({
    label = "Seng msg Ham Radio",
    nodenames = {"ham_radio:transmitter"},
    interval = ham_radio_api.settings.send_interval,
    chance = 1,
    catch_up = false,
    action = function(pos, node)
        local meta = core.get_meta(pos)
        local frequency = meta:get_string("frequency")

        if checkRange(frequency) == false then
            return
        end
        sendToApi(frequency, ham_radio.get_rds_messages(frequency, false))
    end
})

core.register_abm({
    label = "Listen api Ham Radion Broadcast",
    nodenames = {"ham_radio:receiver"},
    interval = ham_radio_api.settings.get_interval,
    chance = 1,
    catch_up = false,
    action = function(pos, node)
        local meta = core.get_meta(pos)
        local frequency = meta:get_string("frequency")

        if checkRange(frequency) == false then
            return
        end

        core.after(ham_radio_api.settings.get_interval * 2, function()
            getApi(frequency)
        end)

        local text = ham_radio_api.frequency[tonumber(frequency)]
        if text then
            local poshash = core.pos_to_string(pos, 0)
            ham_radio.receiver_rds[poshash] = {'Global frequency ' .. text}
        end
    end
})


local function update_transmitter_formspec(fs)
    return fs:gsub(
        "(field%[0.25,2;7,1;frequency;Frequency;${frequency}%])",
        table.concat(
            {
                "%1label[0,2.4;" .. ham_radio_api.settings.api_frequency.min .. ".." .. ham_radio_api.settings.api_frequency.max .. " - " .. S("long range (interserver)") .. "]",
                "label[0,2.7;" .. (ham_radio_api.settings.api_frequency.max + 1) .. ".." .. ham_radio.settings.frequency.max .. " - " .. S("short range") .. "]"
            }, ""
        )
    )
end


local function update_receiver_formspec(fs)
    return fs:gsub(
        "(field%[0.25,2;7,1;frequency;Frequency;${frequency}%])",
        table.concat(
            {
                "%1label[0,2.4;" .. ham_radio_api.settings.api_frequency.min .. ".." .. ham_radio_api.settings.api_frequency.max .. " - " .. S("long range (interserver)") .. "]",
                "label[0,2.7;" .. (ham_radio_api.settings.api_frequency.max + 1) .. ".." .. ham_radio.settings.frequency.max .. " - " .. S("short range") .. "]"
            }, ""
        )
    )
end


local old_transmitter_cb = core.registered_nodes["ham_radio:transmitter"].after_place_node
core.override_item(
    "ham_radio:transmitter",
    {
        after_place_node = function(pos, placer)
            old_transmitter_cb(pos, placer)
            local meta = core.get_meta(pos)
            local fs = meta:get_string("formspec")
            meta:set_string("formspec", update_transmitter_formspec(fs))
        end
    }
)


local old_reciever_cb = core.registered_nodes["ham_radio:receiver"].after_place_node
core.override_item(
    "ham_radio:receiver",
    {
        after_place_node = function(pos, placer)
            old_reciever_cb(pos,placer)
            local meta = core.get_meta(pos)
            local fs = meta:get_string("formspec")
            meta:set_string("formspec", update_receiver_formspec(fs))
        end
    }
)


core.override_item(
    "ham_radio:handheld_receiver",
    {
        on_use = function(itemstack, user, pointed_thing)
            local keys = user:get_player_control()
            local meta = itemstack:get_meta()
            if keys.sneak then
                -- left click with shift - RDS on/off
                local is_rds_disabled = meta:get_string("rds_disabled")
                if is_rds_disabled == "" then
                    meta:set_string("rds_disabled", "true")
                else
                    meta:set_string("rds_disabled", "")
                end
                return itemstack
            end
            local frequency = meta:get_string("frequency")
            minetest.show_formspec(user:get_player_name(), "ham_radio:configure_handheld_receiver",
                table.concat(
                    {
                        "size[4,4]",
                        "image[1.5,0;1,1;ham_radio_receiver_handheld.png]",
                        "field[0.25,1.8;4,1;frequency;Frequency;",tostring(frequency),"]",
                        "label[0,2.3;" .. ham_radio_api.settings.api_frequency.min .. ".." .. ham_radio_api.settings.api_frequency.max .. "]",
                        "label[0,2.6;" .. S("long range (interserver)") .. "]",
                        "label[0,2.9;" .. (ham_radio_api.settings.api_frequency.max + 1) .. ".." .. ham_radio.settings.frequency.max .. "]",
                        "label[0,3.2;" .. S("short range") .. "]",
                        "tooltip[frequency;Integer number ",
                        ham_radio.settings.frequency.min,"-",
                        ham_radio.settings.frequency.max, "]",
                        "button_exit[0,3.5;4,1;;Done]"
                    },''
                )
            )
            return itemstack
        end
    }
)


core.register_lbm(
    {
        name = "ham_radio_api:update_formspec_v1",
        nodenames = { "ham_radio:transmitter", "ham_radio:receiver" },
        run_at_every_load = false,
        action = function(pos, node)
            local meta = core.get_meta(pos)
            local fs = meta:get_string("formspec")
            if fs ~= "" then
                if node.name == "ham_radio:transmitter" then
                    meta:set_string("formspec", update_transmitter_formspec(fs))
                elseif node.name == "ham_radio:receiver" then
                    meta:set_string("formspec", update_receiver_formspec(fs))
                end
            end
        end,
    }
)