# Ham Radio API
Это дополнение для мода Ham Radio, которое позволяет передавать текстовые сообщения между серверами или локальным клиентом через Web API.
Для работы мода необходимо разрешить использование **HTTP/HTTPS**-запросов. Для этого добавьте в minetest.conf строку:
*secure.http_mods = ham_radio_api*

## Принцип работы
В мире разместите передатчик и приёмник, настройте у них частоты передачи и приёма.
Перед использованием убедитесь, что выбранные частоты свободны и на них никто не работает.
Передайте свою частоту другу или знакомому, играющему на другом сервере или клиенте, чтобы наладить связь.
Диапазон частот, передаваемых через Web API можно ограничить с помощью параметров `ham_radio_api.min_frequency` и `ham_radio_api.max_frequency`.

## API
Web API реализован на сайте:
https://apocalypse.texnoblog.uz
На данный момент реализована базовая передача сообщений. В будущем механика может быть расширена.

Пример работы API
>**Передатчик отправляет запрос:**
https://apocalypse.texnoblog.uz/api/hamRadio/set/?frequency=5&text=Текст для трансляции
**Ответ при успешной отправке:**
{
"status": "ok",
"frequency": 5,
"text": "Текст для трансляции"
}

> **Приёмник получает запрос:**
https://apocalypse.texnoblog.uz/api/hamRadio/get/?frequency=67000
**Ответ:**
{
"status": "ok",
"frequency": 67000,
"text": "[ Radio | singleplayer ] test"
}

This is an add-on for the Ham Radio mod that allows transmitting text messages between servers or a local client via a Web API.
To use the mod, you need to enable HTTP/HTTPS requests. To do this, add the following line to your minetest.conf:
secure.http_mods = ham_radio_api

## How it works

Place a transmitter and a receiver in the world, and configure their transmit and receive frequencies.
Before using, make sure the selected frequencies are free and not currently in use.
Share your frequency with a friend or acquaintance playing on another server or client to establish communication.
The frequency range transmitted through the Web API can be limited using the parameters ham_radio_api.min_frequency and ham_radio_api.max_frequency.

## API

The Web API is implemented at:
https://apocalypse.texnoblog.uz

Currently, only basic message transmission is implemented. In the future, the mechanics may be expanded.

Example of API usage:

The transmitter sends a request:
https://apocalypse.texnoblog.uz/api/hamRadio/set/?frequency=5&text=Text+for+broadcast

Response on successful transmission:

{
"status": "ok",
"frequency": 5,
"text": "Text for broadcast"
}


The receiver sends a request:
https://apocalypse.texnoblog.uz/api/hamRadio/get/?frequency=67000

Response:

{
"status": "ok",
"frequency": 67000,
"text": "[ Radio | singleplayer ] test"
}
