#!/usr/bin/env lua
local modname = minetest.get_current_modname()
local S = minetest.get_translator(modname)

minetest.register_privilege("change_speed", S("Speed-changing privilege"))

minetest.register_chatcommand("reset_speed", {
    privs = {
        change_speed = true,
    },
    description = S("Sets speed to default"),
    params = "",
    func = function(name, param)
        local player = minetest.get_player_by_name(name)
        if player then
            if not minetest.check_player_privs(name, "change_speed") then
                return false, S("Not enough privileges to reset your movement speed.")
            end
            player:set_physics_override({speed = 1})
            return true, S("Successfully reset movement speed.")
        end
    end,
})
minetest.register_chatcommand("set_speed", {
    privs = {
        change_speed = true,
    },
    description = S("Set speed <speed> for current player"),
    params = "speed",
    func = function(name, param)
        local player = minetest.get_player_by_name(name)
        if player then
            if not minetest.check_player_privs(name, "change_speed") then
                return false, S("Not enough privileges to change your movement speed.")
            end
            if not param or param == "" then
                return false, S("No speed given.")
            end
            local change_to = tonumber(param)
            if not change_to then return false, S("Speed must be a number.") end
            if minetest.settings:get_bool(modname .. "_" .. "one_hundred_caution_message") and change_to >= 100 then
                minetest.chat_send_player(name, S("CAUTION: You movement speed is now greater than/equal to 100. Please be careful."))
            end
            if minetest.settings:get_bool(modname .. "_" .. "do_not_allow_zero_speed") and change_to <= 0 then
                return false, S("Movement speed cannot be lesser than/equal to zero.")
            end
            player:set_physics_override({speed = param})
            return true, S("Successfully changed movement speed.")
        end
    end,
})


