This modpack provides a library and tools for managing a standard for schematics as Lua code using "ASCII art" to make designing, maintaining, analyzing and comparing large, moderately complex schematics more practical.

This standard is inspired and guided by previous work in **[NodeCore](https://content.minetest.net/packages/Warr1024/nodecore/)**, **[Piranesi Restoration Project](https://content.minetest.net/packages/Warr1024/piranesi_redo/)**, and **[ColourHop](https://content.minetest.net/packages/talas/colourhop/)**, and seeks to standardize the core common functionality.

### Problems with MTS

The Minetest MTS file format is binary and opaque, and diffing/comparing tools don't exist or aren't well integrated with source control systems.  This makes it hard to review changes to schematics in pull requests, history diffs, and patches.

Since Minetest apparently caches loaded schematics forever, only a limited amount of schematic data can be managed in practice.  This means that in order to need to load enough schematics that the binary MTS format has tangible benefits, you are already likely outside of the range of scale where it makes sense to use schematics at all.  Thus the supposed efficiency benefits of MTS are easily outweighed by the added difficulty of managing them.

### The ASCII Art Format

The ASCII art schematic format is a Lua data structure.  Instead of the Minetest schematic flat "data" array, a an array of layers is used, where each layer is an array of strings.  When the layers are formatted by a competent Lua code formatter, they will line up to form a 2D visual map of each vertical slice of the schematic as ASCII art, with North up and East to the right.  Each character of the map represents a node, and a separate character to node definition mapping is supplied as a map legend above.

This format make it very easy to see most topographical structures, orient yourself within the map, and find specific areas where changes need to be made.  It is likely the most convenient format for maintaining changes without use of a 3D schematic editor.  Unlike other Lua formats that try to emulate this while retaining structural compatibility with the standard Minetest format, it's still readable when reformatted by code formatting tools.

The format does not store separate "size" metadata.  Instead, it can be inferred from the layer data itself.  Because of this, all schematics must be full rectangular prisms; "jagged" arrays with inconsistent lengths or missing values are not supported.

### The Library

The `aaschemlib` mod is intended to be used as an API/library by other games/mods.  It provides functions for:

- `asciiart_to_schematic` to convert a Lua ASCII art table into the Lua schematic format that Minetest expects for loading into Minetest.
- `schematic_to_asciiart` to convert MTS files into ASCII art tables.
- `asciiart_to_lua` to serialize ASCII art tables into Lua code, with some conveniences like sorted node type registrations.

The normal workflow would be to include ASCII art schematic data as Lua source files in your project, load them, convert them to Minetest schematic tables using `asciiart_to_schematic`, then perform any analysis/modifications, before registering the schematics in Minetest for later use.

### The Tools

Currently the tools mod adds some chat commands:

- `mts2aa` to load MTS files and convert them into ASCII art code.
- `aa2mts` to load ASCII art code and convert them back into MTS files. *(N.B. this involves executing Lua code from those files)*

The normal workflow here would be:

- Obtain MTS files from a game or mod that you want to import into your project, or create them using **[Schematic Editor](https://content.minetest.net/packages/Wuzzy/schemedit/)**.
- Use `mts2aa` to convert the files into Lua code.
- Import those files into your project as source code.
- Perform most maintenance of them directly in the source code from that point on.
- If you need to make large, complex changes, and need to be able to use a visual editor, you can use `aa2mts` to convert them back so you can use the Schematic Editor on them, then convert them back to AA again.