local modname = minetest.get_current_modname()
local pi = math.pi

local function setting(name, def)
	return tonumber(minetest.settings:get(modname .. "_" .. name)) or def
end

-- Interval of angular units to lock to
local thetah = pi * 2 / setting("horz", 8)
local thetav = pi / setting("vert", 4)

-- Dead zone for detecting deliberate angle change gestures
local deadzoneh = thetah * setting("deadzone", 0.25)
local deadzonev = thetav * setting("deadzone", 0.25)

local pending = {}
local function playerstep(player)
	local pname = player:get_player_name()
	local found = pending[pname]

	local bits = player:get_player_control_bits()
	-- When player first presses Aux1, capture starting angles.
	if bits == 32 then
		if not found then
			pending[pname] = {
				v = player:get_look_vertical(),
				h = player:get_look_horizontal()
			}
		end
		return
	end
	-- If player presses any other control, cancel angle snap.
	pending[pname] = nil
	if bits ~= 0 or not found then return end
	-- If player releases Aux1, apply snap.

	-- If player changed pitch deliberately while holding Aux1,
	-- move angle exactly one stop
	local p = player:get_look_vertical() - found.v
	if p > deadzonev then found.v = found.v + thetav
	elseif p < -deadzonev then found.v = found.v - thetav
	end

	-- If player changed yaw deliberately while holding Aux1,
	-- move yaw exactly one stop. Account for wrap-around.
	local y = player:get_look_horizontal() - found.h
	if y > pi then y = y - pi * 2
	elseif y < -pi then y = y + pi * 2
	end
	if y > deadzoneh then found.h = found.h + thetah
	elseif y < -deadzoneh then found.h = found.h - thetah
	end

	-- Apply snaped in angle.
	player:set_look_vertical(math.floor((found.v / thetav) + 0.5) * thetav)
	player:set_look_horizontal(math.floor((found.h / thetah) + 0.5) * thetah)
end

minetest.register_globalstep(function()
		for _, player in ipairs(minetest.get_connected_players()) do
			playerstep(player)
		end
	end)
