# arclib - Archipelago Client Library for Luanti

A game-agnostic framework for connecting Luanti games to [Archipelago](https://archipelago.gg/) multiworld randomizer servers.  Each game will need its own game-specific mod and corresponding apworld to define its randomization logic and overrides.  This library provides realtime connectivity to the multiworld server for that mod.

## Features

arclib provides the foundational client-side components for Archipelago integration, including:

- **Robust Connection Management**: Automatic reconnection, ping/pong keepalive, and timeout handling
- **WebSocket Connections**: HTTP proxy support to work around Luanti's WebSocket limitations
- **Message Persistence**: Reliable message delivery using Luanti's mod storage with queuing across restarts
- **Protocol Abstraction**: Flexible Archipelago protocol implementation with proper JSON serialization
- **Event System**: Emitter pattern for handling server events and state changes
- **Configuration UI**: Built-in formspec interface for server connection settings
- **Cross-Platform**: Works on all Luanti platforms via HTTP-to-WebSocket proxy

## Requirements

**WebSocket Proxy Required**: arclib is packaged with `websockproxy`, which allows Luanti to connect to websockets, as required by Archipelago but unsupported by Luanti's HTTP API.  An instance of this must be running and accessible to arclib.

Ideally, players (singleplayer) or server operators (multiplayer) should run their own instance of the websockproxy.  One instance of websockproxy is sufficient for any/all running game instances.

The proxy defaults to `http://localhost:9839` and can be configured in the connection settings.

Users who have the Go language tools installed can run `make proxy` in arclib to run the proxy directly from source.  Pre-built versions may be available as `websockproxy/websockproxy-*` binaries for selected platforms.

**HTTP Access Required**: arclib must be added to the Luanti `secure.http_mods` setting in order to load.  Players or server operators must do this manually, by editing the config file or using Luanti's settings interface.

## Usage

See the included `USAGE.md` file for details on using the mod to develop game-specific Archipelago integration mods.

## Persistence

arclib can automatically persist:

- Connection configuration
- Reliable message queue (location checks, goal completion)
- Cached server state

Data is stored using Luanti's mod storage system, in the consumer mod's own mod storage.  Persistence is controlled by downstream mods, which must provide a mod storage object to arclib components to enable it.

## AI Disclosure

This project was developed jointly by human developer(s) and AI coding agent(s). AI models used may include members of the following model families: [OpenCode Zen](https://opencode.ai/zen) Big Pickle ([based on GLM-4.x](https://github.com/sst/opencode/issues/4276#issuecomment-3527229513)), and Copilot Anthropic Claude 4.x. Agent access to the project was managed by SST's [OpenCode](https://opencode.ai/) tool.