# arclib - Archipelago Client Library for Luanti

A game-agnostic framework for connecting Luanti games to [Archipelago](https://archipelago.gg/) multiworld randomizer servers.  Each game will need its own game-specific mod and corresponding apworld to define its randomization logic and overrides.  This library provides realtime connectivity to the multiworld server for that mod.

## Features

arclib provides the foundational client-side components for Archipelago integration, including:

- **Robust Connection Management**: Automatic reconnection, ping/pong keepalive, and timeout handling
- **WebSocket Connections**: HTTP proxy support to work around Luanti's WebSocket limitations
- **Message Persistence**: Reliable message delivery using Luanti's mod storage with queuing across restarts
- **Protocol Abstraction**: Flexible Archipelago protocol implementation with proper JSON serialization
- **Event System**: Emitter pattern for handling server events and state changes
- **Configuration UI**: Built-in formspec interface for server connection settings
- **Cross-Platform**: Works on all Luanti platforms via HTTP-to-WebSocket proxy

## Requirements

**WebSocket Proxy Required**: arclib is packaged with `websockproxy`, which allows Luanti to connect to websockets, as required by Archipelago but unsupported by Luanti's HTTP API.  An instance of this must be running and accessible to arclib.

Ideally, players (singleplayer) or server operators (multiplayer) should run their own instance of the websockproxy.  One instance of websockproxy is sufficient for any/all running game instances.

The proxy defaults to `http://localhost:9839` and can be configured in the connection settings.

Users who have the Go language tools installed can run `make proxy` in arclib to run the proxy directly from source.  Pre-built versions may be available as `websockproxy/websockproxy-*` binaries for selected platforms.

**HTTP Access Required**: arclib must be added to the Luanti `secure.http_mods` setting in order to load.  Players or server operators must do this manually, by editing the config file or using Luanti's settings interface.

## Usage

arclib is designed for two audiences:

- **Players / server operators** who just need to connect a Luanti game that depends on arclib to an Archipelago server.
- **Mod developers** who are building a game-specific integration mod on top of arclib.

### For players and server operators

1. Ensure the game/mod that depends on arclib is installed and enabled.
2. Make sure `arclib` is allowed to use HTTP:
   - Add `arclib` to the `secure.http_mods` setting (via Luanti settings or `luanti.conf`).
3. Start the bundled WebSocket proxy:
   - If a suitable `websockproxy-*` binary exists for your platform under `websockproxy/`, run it directly.
   - Otherwise, with Go installed, run `make proxy` from the arclib directory to build and run from source.
   - By default the proxy listens on `http://localhost:9839`.
4. In-game, open the Archipelago configuration UI provided by your game-specific mod (often via a chat command like `/ap`). There you can:
   - Set the Archipelago server URL (WebSocket URL).
   - Set your slot name and password.
   - Verify or adjust the WebSocket proxy URL (usually `http://localhost:9839`).
5. Save and connect. Once connected, the game will exchange items and locations with the Archipelago multiworld according to its own rules.

### For mod developers

See `USAGE.md` for details on using arclib from your mod, including the manager API, UX helpers, and state structure.

## Persistence

arclib can automatically persist:

- Connection configuration
- Reliable message queue (location checks, goal completion)
- Cached server state

Data is stored using Luanti's mod storage system, in the consumer mod's own mod storage.  Persistence is controlled by downstream mods, which must provide a mod storage object to arclib components to enable it.

## AI Disclosure

This project was developed jointly by human developer(s) and AI coding agent(s). AI models used may include members of the following model families: [OpenCode Zen](https://opencode.ai/zen) Big Pickle ([based on GLM-4.x](https://github.com/sst/opencode/issues/4276#issuecomment-3527229513)), and Copilot Anthropic Claude 4.x. Agent access to the project was managed by SST's [OpenCode](https://opencode.ai/) tool.