# arclib - Archipelago Client Library for Luanti

A game-agnostic framework for connecting Luanti games to [Archipelago](https://archipelago.gg/) multiworld randomizer servers. Each game will need its own game-specific mod and corresponding apworld to define its randomization logic and overrides. This library provides realtime connectivity to the multiworld server for that mod.

## Features

arclib provides the foundational client-side components for Archipelago integration, including:

- **Robust Connection Management**: Automatic reconnection, ping/pong keepalive, and timeout handling
- **WebSocket Connections**: HTTP proxy support to work around Luanti's WebSocket limitations
- **Persistence**: Uses Luanti mod storage (in the consumer mod) to persist connection configuration, reliable message queues (location checks, goal completion), and cached server state when configured
- **Protocol Abstraction**: Flexible Archipelago protocol implementation with proper JSON serialization
- **Event System**: Emitter pattern for handling server events and state changes
- **Configuration UI**: Built-in formspec interface for server connection settings
- **Cross-Platform**: Works on all Luanti platforms via HTTP-to-WebSocket proxy

## Requirements

These requirements apply to both players and developers whenever the game is running and trying to connect to Archipelago.

- **WebSocket proxy (`websockproxy`)**
  - arclib is packaged with an HTTP-to-WebSocket proxy, `websockproxy`, which allows Luanti to connect to WebSocket servers such as Archipelago.
  - A proxy instance must be running and reachable while the game is connected.
  - By default the proxy listens on `http://localhost:9839`.
  - If a suitable `websockproxy-*` binary exists for your platform under `websockproxy/`, you can run it directly. Otherwise, with Go installed, run `make` or `make proxy` from the `websockproxy` directory to build and run from source.

- **HTTP access (`secure.http_mods`)**
  - arclib must be added to the Luanti `secure.http_mods` setting so it can use the HTTP API.
  - Configure this once per Luanti installation, via the in-game settings UI or by editing `luanti.conf`.

## Usage (players / server operators)

1. Install and enable the game or mod that depends on arclib.
2. Ensure the **Requirements** above are satisfied (proxy running, `secure.http_mods` includes `arclib`).
3. Start Luanti and load the world containing the game-specific mod.
4. In-game, open the Archipelago configuration UI provided by the game-specific mod (often via a chat command like `/ap`). There you can:
   - Set the Archipelago server URL (WebSocket URL).
   - Set your slot name and password.
   - Verify or adjust the WebSocket proxy URL if you are not using the default.
5. Save and connect. Once connected, the game will exchange items and locations with the Archipelago multiworld according to its own rules.

## Usage (developers)

- The **Requirements** section above (proxy + `secure.http_mods`) also applies whenever you run or test your mod.
- See `USAGE.md` for details on using arclib from your mod, including the manager API, UX helpers, state structure, and notes on common multiplayer patterns.

## AI Disclosure

This project was developed jointly by human developer(s) and AI coding agent(s). AI models used may include members of the following model families: [OpenCode Zen](https://opencode.ai/zen) Big Pickle ([based on GLM-4.x](https://github.com/sst/opencode/issues/4276#issuecomment-3527229513)), and Copilot Anthropic Claude 4.x. Agent access to the project was managed by SST's [OpenCode](https://opencode.ai/) tool.