-- LUALOCALS < ---------------------------------------------------------
local math, minetest, pairs, vector
    = math, minetest, pairs, vector
local math_abs, math_floor, math_pi
    = math.abs, math.floor, math.pi
-- LUALOCALS > ---------------------------------------------------------

local hpi = math_pi / 2
local now

local huds = {}
local function hudupdate(player, name, tog)
	if tog then
		player:hud_set_flags({crosshair = false})
		huds[name] = player:hud_add({
				hud_elem_type = "image",
				position = {x = 0.5, y = 0.5},
				scale = {x = 1, y = 1},
				text = "autotrek_hud.png",
				number = 0xFFFFFF,
				alignment = {x = 0, y = 0},
				offset = {x = 0, y = 0},
			})
	elseif huds[name] then
		player:hud_remove(huds[name])
		player:hud_set_flags({crosshair = true})
		huds[name] = nil
	end
end

local function issolid(pos)
	local node = minetest.get_node_or_nil(pos)
	local def = node and minetest.registered_nodes[node.name]
	return def and def.walkable
end

local function voffs(v, dy)
	return {x = v.x, y = v.y + dy, z = v.z}
end

local function iswall(pos)
	return issolid(pos) and issolid(voffs(pos, 1))
end

local function isfloor(pos)
	return not iswall(pos) and issolid(voffs(pos, -1))
end

local function turncheck(player, pos, fwd, theta)
	local turn = vector.round(minetest.yaw_to_dir(theta + minetest.dir_to_yaw(fwd)))
	local function rel(f, t)
		return vector.add(vector.add(pos,
				vector.multiply(fwd, f)),
			vector.multiply(turn, t))
	end
	if isfloor(rel(0, 1)) and iswall(rel(0, -1)) and iswall(rel(-1, 1)) then
		player:set_look_horizontal(math_floor(player:get_look_horizontal()
				/ hpi + 0.5) * hpi + theta)
		return true
	end
end

local oldpos = {}
local pstats = {}
local function autofwdcheck(player)
	local name = player:get_player_name()
	local s = pstats[name]
	if not s then
		s = {}
		pstats[name] = s
	end
	local function nope()
		pstats[name] = {}
		if s.ok then return hudupdate(player, name) end
	end

	local ctl = player:get_player_control_bits()
	if ctl ~= 0 and ctl ~= 16 then return nope() end

	local dir = player:get_look_pitch()
	if math_abs(dir) > 1 then return nope() end
	if not s.dir then s.dir = dir end
	if dir ~= s.dir then return nope() end

	local fwd = minetest.yaw_to_dir(3 * hpi + player:get_look_yaw())
	local rfwd = minetest.wallmounted_to_dir(minetest.dir_to_wallmounted(fwd))
	local yawerr = math_abs(vector.distance(fwd, rfwd))
	if yawerr > 0.1 then return nope() end

	if not s.time then
		s.time = now
		s.pos = player:get_pos()
		return
	end
	local pos = player:get_pos()
	if now >= (s.time + 1) then
		if vector.distance(pos, s.pos or pos) <= (now - s.time) then return nope() end
		if not s.ok then hudupdate(player, name, true) end
		s.ok = true
		s.time = now
		s.pos = pos
	end
	if not s.ok then return end

	local rpos = vector.round(pos)
	local opos = oldpos[name]
	if (not opos) or (not vector.equals(opos, rpos)) then
		oldpos[name] = rpos

		if isfloor(rpos) and iswall(vector.add(rpos, rfwd)) then
			return turncheck(player, rpos, rfwd, hpi)
			or turncheck(player, rpos, rfwd, -hpi)
		end
	end

	local cpos = (math_abs(fwd.x) > 0.1)
	and {x = pos.x, y = pos.y, z = math_floor(pos.z + 0.5)}
	or {x = math_floor(pos.x + 0.5), y = pos.y, z = pos.z}
	if yawerr < 0.1 and (yawerr > 0.001 or vector.distance(pos, cpos) > 0.1) then
		player:set_look_horizontal(math_floor(player:get_look_horizontal()
				/ hpi + 0.5) * hpi)
		return player:set_pos(cpos)
	end
end

minetest.register_globalstep(function(dtime)
		now = (now or minetest.get_gametime()) + dtime
		for _, player in pairs(minetest.get_connected_players()) do
			autofwdcheck(player)
		end
	end)
