-- LUALOCALS < ---------------------------------------------------------
local math, tonumber
    = math, tonumber
local math_floor
    = math.floor
-- LUALOCALS > ---------------------------------------------------------

local stamp = tonumber("$Format:%at$")
if not stamp then return end
stamp = math_floor((stamp - 1540612800) / 60)
stamp = ("00000000" .. stamp):sub(-8)

-- luacheck: push
-- luacheck: globals config readtext readbinary

readtext = readtext or function() end
readbinary = readbinary or function() end

return {
	user = "Warr1024",
	pkg = "autotrek",
	min = "5.0",
	version = stamp .. "-$Format:%h$",
	path = ".",
	type = "mod",
	title = "Auto-Trek",
	short_desc = "Automatic long-distance walking via assisted auto-forward",
	tags = "transport, player effect",
	license = "mit",
	desc = readtext('README.md'),
	repo = "https://gitlab.com/sztest/autotrek",
	screenshots = {
		readbinary('.cdb-screenshot.png')
	}
}

-- luacheck: pop
