-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore, pairs
    = math, minetest, nodecore, pairs
local math_cos, math_floor, math_pi, math_random
    = math.cos, math.floor, math.pi, math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local api = _G[modname]

local cache = {}

function api.playerdata(player)
	local pname = player:get_player_name()
	local data = cache[pname]
	if not data then
		data = player:get_meta():get_string(modname)
		data = data and data ~= "" and minetest.deserialize(data) or {}
		cache[pname] = data
	end
	return data, function()
		return player:get_meta():set_string(modname,
			minetest.serialize(data))
	end
end

local fademax = 4

local function setfade(player, fade)
	local txr = "[combine:16x16^[noalpha^[opacity:"
	.. math_floor((0.5 - 0.5 * math_cos(fade / fademax * math_pi)) * 16) * 16
	nodecore.hud_set(player, {
			label = modname .. " fade",
			hud_elem_type = "image",
			position = {x = 0.5, y = 0.5},
			text = txr,
			direction = 0,
			scale = {x = -100, y = -100},
			offset = {x = 0, y = 0}
		})
end

local function player_move(player, pos)
	player:set_pos(pos)
	player:set_look_horizontal(math_random() * 2 * math_pi)
end

function api.player_enter(player, pos, portalpos)
	local data, save = api.playerdata(player)
	data.oldrtn = {
		rtn = data.rtn,
		portal = data.portal,
		old = data.oldrtn
	}
	data.rtn = player:get_pos()
	data.portal = portalpos
	data.fade = fademax
	setfade(player, fademax)
	nodecore.inventory_dump(player)
	nodecore.setphealth(player, 0)
	nodecore.sound_play("player_damage", {pos = data.rtn})
	player_move(player, pos)
	nodecore.sound_play("player_damage", {pos = pos})
	return save()
end

function api.player_return(player)
	local ppos = player:get_pos()
	local data, save = api.playerdata(player)
	data.fade = fademax
	setfade(player, fademax)
	nodecore.sound_play("player_damage", {pos = ppos})
	local dest = data.rtn or {x = 0, y = 64, z = 0}
	dest.keepinv = true
	player_move(player, dest)
	nodecore.sound_play("player_damage", {pos = dest})
	nodecore.inventory_dump(player)
	nodecore.setphealth(player, 0)
	if data.oldrtn then
		data.rtn = data.oldrtn.rtn
		data.portal = data.oldrtn.portal
		data.oldrtn = data.oldrtn.old
	end
	return save()
end

local function scanup(pos)
	local node = minetest.get_node(pos)
	if node.name == "ignore" then return pos end
	if node.name == "air" then
		pos.y = pos.y + 1
		node = minetest.get_node(pos)
		if node.name == "ignore" then return pos end
		if node.name == "air" then return pos, true end
		return scanup(pos)
	end
	pos.y = pos.y + 1
	return scanup(pos)
end

local function checkplayer(player, dtime)
	local data, save = api.playerdata(player)
	if not data.fade then return end
	if data.fade == fademax then
		local pos, ok = scanup(player:get_pos())
		player_move(player, pos)
		if ok then data.fade = data.fade - dtime end
	elseif data.fade <= 0 then
		nodecore.hud_set(player, {
				label = modname .. " fade",
				ttl = 0,
				quick = true
			})
		data.fade = nil
	elseif data.fade then
		setfade(player, data.fade)
		data.fade = data.fade - dtime
	end
	return save()
end
minetest.register_globalstep(function(dtime)
		for _, player in pairs(minetest.get_connected_players()) do
			checkplayer(player, dtime)
		end
	end)
