-- LUALOCALS < ---------------------------------------------------------
local core, error, loadfile, string, unpack
    = core, error, loadfile, string, unpack
local string_sub
    = string.sub
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

local api = {}

local include
do
	local included = {}
	include = function(rel)
		local fullpath = modpath .. "/" .. rel
		if string_sub(fullpath, -4) ~= ".lua" then
			fullpath = fullpath .. ".lua"
		end
		local found = included[fullpath]
		if found then return unpack(found) end
		local func, err = loadfile(fullpath)
		if not func then error(err) end
		local loaded = {func(api)}
		included[fullpath] = loaded
		return unpack(loaded)
	end
	api.include = include
end

api.plantdata = {
	{pos = {x = 37, y = 7, z = 19}, plant = "vine",
		time = 3, item = "citadel_core:vine_bud"},
	{pos = {x = 35, y = 2, z = 32}, plant = "bamboo",
		time = 2, item = "citadel_core:bamboo_shoot"},
	{pos = {x = 3, y = 2, z = 19}, plant = "tree",
		time = 1, item = "citadel_core:acorn"},
	{pos = {x = 43, y = 1, z = 2}, plant = "big_tree",
		time = 3, item = "citadel_core:big_acorn"},
}

include("setup")
include("node")
include("locations")
include("items")
include("goal")
