-- LUALOCALS < ---------------------------------------------------------
local core, ipairs
    = core, ipairs
-- LUALOCALS > ---------------------------------------------------------

local api = ...

local modname = core.get_current_modname()
local myname = modname .. ":apitem"

core.register_node(myname, {
		drawtype = "airlike",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		on_construct = arclib.itemvis.node_apply,
		after_destruct = arclib.itemvis.node_apply,
		on_punch = function(pos)
			core.sound_play("citadel_archipelago_send", {pos = pos}, true)
			api.manager:check_location(core.get_meta(pos):get_float("id"))
			for _, v in ipairs(arclib.itemvis.inside_radius(pos, 0.5)) do
				v:explode()
			end
			core.remove_node(pos)
		end
	})

arclib.itemvis.node_register({myname})
