-- LUALOCALS < ---------------------------------------------------------
local core, io
    = core, io
local io_open
    = io.open
-- LUALOCALS > ---------------------------------------------------------

local api = ...
local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local modstore = core.get_mod_storage()

-- Create shared arclib manager instance
api.manager = arclib.manager({
		url_server = nil,
		login_slotname = nil,
		login_password = nil,
		login_gamename = "Luanti Citadel",
		modstore = modstore,
	})

-- Persist config, and command to access it
arclib.ux.configure({
		modstore = modstore,
		manager = api.manager
	})
core.register_chatcommand("ap", {
		description = "Show Archipelago config form",
		func = function(name)
			arclib.ux.configure({
					modstore = modstore,
					player = name,
					manager = api.manager,
				})
		end
	})

-- Always disconnect on shutdown
core.register_on_shutdown(function()
		api.manager:close()
	end)

-- game <-> arc chat bridge
api.manager.on("printtext", core.chat_send_all)
core.register_on_chat_message(function(_, msg)
		api.manager:say(msg)
	end)

-- Load apdata from JSON
do
	local f = io_open(modpath .. "/apdata.json")
	api.apdata = core.parse_json(f:read("*all"))
	f:close()
end
