-- LUALOCALS < ---------------------------------------------------------
local core, ipairs, pairs, string
    = core, ipairs, pairs, string
local string_format
    = string.format
-- LUALOCALS > ---------------------------------------------------------

local api = ...

local modname = core.get_current_modname()

local hudidx = {}

core.register_on_leaveplayer(function(player)
		hudidx[player:get_player_name()] = nil
	end)

local function updatehud_player(player)
	local state = api.manager.state

	local text = ""
	if state and state.slot_data then
		local checked = {}
		for _, i in ipairs(state and state.checked_locations or {}) do
			checked[i] = true
		end
		core.chat_send_all("TEXT: " .. core.serialize(checked))
		local done = 0
		local total = 0
		for _, metadata in pairs(api.apdata.items) do
			if checked[metadata.id + 1000] then done = done + 1 end
			total = total + 1
		end
		text = string_format("Checked %d / %d (%d%%)",
			done, total, done * 100 / total)
	end

	local pname = player:get_player_name()
	local hud = hudidx[pname]
	if not hud then
		hud = {}
		hudidx[pname] = hud
	end

	if hud.id and hud.text ~= text then
		player:hud_change(hud.id, "text", text)
	else
		hud.id = player:hud_add({
				type = "text",
				position = {x = 1, y = 1},
				text = text,
				number = 0xFFFFFF,
				alignment = {x = -1, y = -1},
				offset = {x = -4, y = -4},
				z_index = -300,
			})
	end
	hud.text = text
end

local function updatehuds()
	for _, player in ipairs(core.get_connected_players()) do
		updatehud_player(player)
	end
end

api.manager.on("update", updatehuds)

core.register_on_joinplayer(updatehuds)
