-- LUALOCALS < ---------------------------------------------------------
local core, ipairs
    = core, ipairs
-- LUALOCALS > ---------------------------------------------------------

local api = ...

local modname = core.get_current_modname()
local myname = modname .. ":apitem"

core.register_node(myname, {
		drawtype = "airlike",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		on_construct = arclib.itemvis.node_apply,
		after_destruct = arclib.itemvis.node_apply,
		on_punch = function(pos, _, puncher)
			-- -- Disallow collection when player's feet are below the bottom
			-- -- of the item (anti-cheese, intended collection mechanic from
			-- -- vanilla game when items were "flat on ground")
			-- local ppos = puncher and puncher:get_pos()
			-- if ppos and ppos.y < pos.y - 0.5 then return end

			core.sound_play("citadel_archipelago_send", {pos = pos}, true)
			api.manager:check_location(core.get_meta(pos):get_float("id"))
			for _, v in ipairs(arclib.itemvis.inside_radius(pos, 0.5)) do
				v:explode()
			end
			core.remove_node(pos)
		end,
		_arclib_get_location_flags = function(pos)
			local id = core.get_meta(pos):get_float("id")
			local info = api.manager:location_info(id)
			local flags = {}
			if info.hint_status and info.item_flags then
				for k in pairs(info.item_flags) do
					flags[k] = true
				end
			end
			if info.hint_status then flags[info.hint_status] = true end
			if info.item_flags and info.item_flags.progression then
				flags.progression = true
			end
			return flags
		end,
	})

arclib.itemvis.node_register({myname})
