-- LUALOCALS < ---------------------------------------------------------
local core, ipairs
    = core, ipairs
-- LUALOCALS > ---------------------------------------------------------

local api = ...

local modname = core.get_current_modname()
local myname = modname .. ":apitem"

core.register_node(myname, {
		drawtype = "airlike",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		on_construct = arclib.itemvis.node_apply,
		after_destruct = arclib.itemvis.node_apply,
		on_punch = function(pos, _, puncher)
			local id = core.get_meta(pos):get_float("id")

			local meta = api.apdata.locations[id]
			if meta and meta.above_only then
				-- Disallow collection when player is too far below the
				-- item (anti-cheese, intended collection mechanic
				-- from vanilla game when items were "flat on ground")
				local ppos = puncher and puncher:get_pos()
				if ppos and ppos.y < pos.y - 1.5 then
					if puncher then
						core.chat_send_player(puncher:get_player_name(),
						"This location cannot be checked from below!")
					end
					return
				end
			end

			core.sound_play("citadel_archipelago_send", {pos = pos}, true)
			api.manager:check_location(id)
			for _, v in ipairs(arclib.itemvis.inside_radius(pos, 0.5)) do
				v:explode()
			end
			core.remove_node(pos)
		end,
		_arclib_get_location_flags = function(pos)
			local id = core.get_meta(pos):get_float("id")
			local info = api.manager:location_info(id)
			return arclib.itemvis.standard_flags(info)

		end,
	})

arclib.itemvis.node_register({myname})
