-- LUALOCALS < ---------------------------------------------------------
local core, io, ipairs, pairs
    = core, io, ipairs, pairs
local io_open
    = io.open
-- LUALOCALS > ---------------------------------------------------------

local api = ...
local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local modstore = core.get_mod_storage()

-- Create shared arclib manager instance
api.manager = arclib.manager({
		url_server = nil,
		login_slotname = nil,
		login_password = nil,
		login_gamename = "Luanti Citadel",
		modstore = modstore,
	})
core.register_on_shutdown(function()
		api.manager:close()
	end)

-- Standard configuration chat command
arclib.ux.configure_command({
		modstore = modstore,
		manager = api.manager
	})

-- Standard chat bridging
arclib.ux.chat_bridge(api.manager)

-- Load apdata from JSON
do
	local f = io_open(modpath .. "/apdata.json")
	api.apdata = core.parse_json(f:read("*all"))
	f:close()

	-- Index by location ID
	api.apdata.locations = {}
	for k, v in pairs(api.apdata.items) do
		v.name = k
		api.apdata.locations[v.id + 1000] = v
	end
end

-- Warn on version mismatch
do
	local warnmsg = core.colorize("#ff4000",
	"WARNING: client mod and apworld version mismatch!")
	local warned = {}
	local function warncheck()
		local state = api.manager.state
		local slotdata = state and state.slot_data
		if (not slotdata) or slotdata.hash == api.apdata.hash then return end
		for _, player in ipairs(core.get_connected_players()) do
			local pname = player:get_player_name()
			if not warned[pname] then
				warned[pname] = true
				core.chat_send_player(pname, warnmsg)
			end
		end
	end
	api.manager.on("update", warncheck)
	core.register_on_joinplayer(warncheck)
	core.register_on_leaveplayer(function(player)
			warned[player:get_player_name()] = nil
		end)
end
