# citadel_archipelago - Citadel Archipelago Client Mod

This mod acts as the client-side bridge between **[Citadel](https://content.luanti.org/packages/_Irevol_/citadel/)** and an **[Archipelago multiworld randomizer](https://archipelago.gg/)** server. It handles:

- **Item Reception** - Receives items from other players and adds them to inventory
- **Location Checks** - Sends checks when completing objectives and collecting items
- **Chat Integration** - Bridges game chat with Archipelago server chat

The mod is also packaged with **[citadel.apworld](https://gitlab.com/sztest/citadel-archipelago/-/raw/main/citadel.apworld)**, the Archipelago server-side component (a zip file containing source code and data that defines the game's configuration and logic).

## Dependencies

This mod requires:
- **(Citadel)[https://content.luanti.org/packages/_Irevol_/citadel/]** game
- **[arclib](https://content.luanti.org/packages/Warr1024/arclib/)** - Archipelago communication library (external dependency) including the packaged proxy application

## Installation

1. Install the `citadel_archipelago` mod to your Luanti mods folder. Recommended method is installation via the Content browser.

2. Enable the mod when creating a new Citadel world.

## Setup

Before playing, you need to join an Archipelago multiworld:

### Step 1: Prepare Your Player Files

1. **Copy the example YAML**: Edit `example-player.yaml` with your preferred player name and settings
2. **Send to host**: Give your YAML file to the person hosting the multiworld

### Step 2: Provide Game Package

Give the `citadel.apworld` file (included with this mod) to the multiworld host. They need this to generate the randomized world.

### Step 3: Wait for Multiworld

The host will generate the multiworld and provide you with:
- Server address (e.g., `wss://archipelago.gg:54321`)
- Your slot name (matches your YAML file name)
- Room password (if required)

## Usage

### Step 1: Start WebSocket Proxy

Before connecting, you must run the WebSocket proxy:
1. The WebSocket proxy is included with the `arclib` dependency
2. Run the proxy (binary for your platform or run from source) from a terminal/command prompt
3. The proxy will listen on `http://localhost:9839`

### Step 2: Connect to Archipelago

In-game, use the `/ap` command to open the configuration form and enter:
- **Server URL** - The server address from your host
- **Slot Name** - Your player name from the YAML file
- **Password** - Room password (if required)

Click "Connect" to join the multiworld.

### Step 3: Play!

As you explore Citadel:

- Send checks where your tools and treasures would be found.
- Receive items and treasures from the multiworld.
- Progress through the game with the help of items from other worlds.
- Chat with other players on the Archipelago server.

## Features

### Item Handling

The mod processes received items by adding them directly to your inventory. This includes tools that will help you progress through Citadel, and treasures found in your Journal.

### Location Checks

Location checks are found where your tools (stones, plants) and treasures would normally be found.  You may have to find creative routes to them, if you're used to having more tools available to you before searching for them.

### Chat Bridge

In-game chat is bridged to Archipelago. See items other players are sending, use commands like !hint, and chat with other players on the Archipelago server.

## AI Disclosure

This project was developed jointly by human developer(s) and AI coding agent(s). AI model(s) used includes [OpenCode Zen](https://opencode.ai/zen) Big Pickle ([based on GLM-4.x](https://github.com/sst/opencode/issues/4276#issuecomment-3527229513)). Agent access to the project was managed by SST's [OpenCode](https://opencode.ai/) tool.
