-- LUALOCALS < ---------------------------------------------------------
local citadel, core, ipairs, pairs
    = citadel, core, ipairs, pairs
-- LUALOCALS > ---------------------------------------------------------

local api = ...

local modname = core.get_current_modname()
local modstore = core.get_mod_storage()
local storeget = arclib.util.structstore(modstore)

-- Keep track independently whether plants are placed
-- in the world, so we don't give duplicate items.
local is_plant_placed
do
	local item_to_plant = {}
	for _, v in ipairs(api.plantdata) do
		item_to_plant[v.item] = v.plant
	end
	local data, save = storeget("plants_placed")
	is_plant_placed = function(plant)
		plant = item_to_plant[plant] or plant
		return data[plant]
	end
	local function planttrack(k, trackval)
		local old = citadel[k]
		citadel[k] = function(pos, plant, ...)
			data[plant] = trackval
			save()
			return old(pos, plant, ...)
		end
	end
	planttrack("record_plant", true)
	planttrack("unrecord_plant", nil)
end

local metabyid = {}
for _, v in pairs(api.apdata.items) do
	metabyid[v.id] = v
end

local function giveitems()
	local state = api.manager.state

	-- Must have received items array
	local recvd = state and state.items_received
	if not recvd then return end

	-- Get player inventory
	local player = (core.get_connected_players())[1]
	if not player then return end
	local inv = player:get_inventory()

	-- Don't allow items to be received in the intro area,
	-- must enter the actual arena first.
	local pos = player:get_pos()
	if pos.x < -1.5 or pos.y < -1.5 or pos.z < -1.5
	or pos.x > 46.5 or pos.y > 33.5 or pos.z > 44.5
	then return core.after(1, giveitems) end

	-- Reconcile every received item, keep track of whether
	-- we need to retry anything.
	for i = 1, #recvd do
		local meta = metabyid[recvd[i].item]
		local name = meta and meta.citadel_inventory
		if name and not is_plant_placed(name) then
			local def = core.registered_items[name]
			if def and def._citadel_inv_slot then
				if inv:get_stack("main", def._citadel_inv_slot):get_name() ~= name then
					core.sound_play("citadel_archipelago_recv_tool",
						{object = player}, true)
					inv:set_stack("main", def._citadel_inv_slot, name)
				end
			else
				name = core.registered_items[name .. "_node"]
				and (name .. "_node") or name
				local meta = player:get_meta()
				if meta:get_string(name) == "" then
					core.sound_play("citadel_archipelago_recv_treasure",
						{object = player}, true)
					meta:set_string(name, "obtained")
				end
			end
		end
	end
end

api.manager.on("update", giveitems)

core.register_on_joinplayer(giveitems)
