-- LUALOCALS < ---------------------------------------------------------
local core, ipairs, pairs, string, type
    = core, ipairs, pairs, string, type
local string_format
    = string.format
-- LUALOCALS > ---------------------------------------------------------

local api = ...

local modname = core.get_current_modname()

local hudidx = {}

core.register_on_leaveplayer(function(player)
		hudidx[player:get_player_name()] = nil
	end)

local function pct(cur, max)
	if max == 0 or not max then return 0 end
	return cur * 100 / max
end

local function logic(owned, obj)
	if type(obj) ~= "table" then
		return owned[obj]
	end
	if obj.need and obj.candidates then
		local total = 0
		for _, c in ipairs(obj.candidates) do
			if logic(owned, c) then
				total = total + 1
			end
		end
		return total >= obj.need
	end
	for _, v in ipairs(obj) do
		if not logic(owned, v) then
			return
		end
	end
	return true
end

local function updatehud_player(player)
	local state = api.manager.state

	local lut = {}
	for _, meta in pairs(api.apdata.items or {}) do
		lut[meta.id] = meta
	end

	local owned = {}
	for _, item in ipairs(state and state.items_received or {}) do
		local meta = lut[item.item]
		owned[meta and meta.name or item.item] = true
	end

	local text = ""
	if state and state.slot_data then
		local checked = {}
		for _, i in ipairs(state and state.checked_locations or {}) do
			checked[i] = true
		end
		local done = 0
		local total = 0
		local in_done = 0
		local in_total = 0
		for _, metadata in pairs(api.apdata.items) do
			if logic(owned, metadata.requires or {}) then
				if checked[metadata.id + 1000] then in_done = in_done + 1 end
				in_total = in_total + 1
			end
			if checked[metadata.id + 1000] then done = done + 1 end
			total = total + 1
		end
		text = string_format("In Logic %d / %d (%d%%)\nAll Checks %d / %d (%d%%)",
			in_done, in_total, pct(in_done, in_total),
			done, total, pct(done, total))
	end

	local pname = player:get_player_name()
	local hud = hudidx[pname]
	if not hud then
		hud = {}
		hudidx[pname] = hud
	end

	if hud.id then
		if hud.text ~= text then
			player:hud_change(hud.id, "text", text)
		end
	else
		hud.id = player:hud_add({
				type = "text",
				position = {x = 1, y = 1},
				text = text,
				number = 0xFFFFFF,
				alignment = {x = -1, y = -1},
				offset = {x = -4, y = -4},
				z_index = -300,
			})
	end
	hud.text = text
end

local function updatehuds()
	for _, player in ipairs(core.get_connected_players()) do
		updatehud_player(player)
	end
end

api.manager.on("update", updatehuds)

core.register_on_joinplayer(updatehuds)
