-- LUALOCALS < ---------------------------------------------------------
local error, ipairs, math, minetest, pairs, string, table, tostring,
      type
    = error, ipairs, math, minetest, pairs, string, table, tostring,
      type
local math_floor, string_format, string_gsub, string_match,
      table_concat, table_sort
    = math.floor, string.format, string.gsub, string.match,
      table.concat, table.sort
-- LUALOCALS > ---------------------------------------------------------

local function sortedpairs(tbl)
	local keys = {}
	for k in pairs(tbl) do keys[#keys + 1] = k end
	table_sort(keys)
	local i = 0
	return function()
		i = i + 1
		local k = keys[i]
		if k == nil then return end
		return k, tbl[k]
	end
end

local bytype = {}

local function dumptable(obj, ctx)
	local bt = bytype[type(obj)]
	if bt then return bt(obj, ctx) end
	return error(string_format("unsupported type %q", type(obj)))
end

function bytype.string(obj)
	return string_format("%q", minetest.get_translated_string("en", obj))
end

bytype.boolean = tostring
bytype.number = tostring

local function dumptableraw(obj, ctx)
	local ents = {}
	local oldindent = ctx.indent
	ctx.indent = ctx.indent .. "\t"
	for i, v in ipairs(obj) do
		local oldpath = ctx.path
		ctx.path = oldpath and (oldpath .. "_" .. i) or i
		ents[#ents + 1] = dumptable(v, ctx)
		ctx.path = oldpath
	end
	for k, v in sortedpairs(obj) do
		if type(k) ~= "number" or k < 1 or k > #obj or k ~= math_floor(k) then
			local oldpath = ctx.path
			local nk = string_gsub(k, "%W", "_")
			ctx.path = oldpath and (oldpath .. "_" .. nk) or nk
			if type(k) == "string" and string_match(k, "^[A-Za-z_][A-Za-z0-9_]*$") then
				ents[#ents + 1] = k .. " = " .. dumptable(v, ctx)
			else
				ents[#ents + 1] = "[" .. dumptable(k, ctx)
				.. "] = " .. dumptable(v, ctx)
			end
			ctx.path = oldpath
		end
	end
	ctx.indent = oldindent
	local short = "{" .. table_concat(ents, ", ") .. "}"
	if #short <= 60 then return short end
	return "{" .. table_concat(ents, ",\n" .. ctx.indent) .. "}"
end

function bytype.table(obj, ctx)
	if ctx.locals then
		local oldindent = ctx.indent
		ctx.indent = "\t"
		local oldlocals = ctx.locals
		ctx.locals = nil
		local raw = dumptableraw(obj, ctx)
		ctx.locals = oldlocals
		ctx.indent = oldindent
		local found = ctx.locals(raw, ctx, obj)
		if found ~= nil then return found end
	end
	ctx.indent = ctx.indent or "\t"
	return dumptableraw(obj, ctx)
end

bytype["nil"] = function() return "nil" end
bytype["function"] = bytype["nil"]
bytype["userdata"] = bytype["nil"]

return dumptable, sortedpairs
