# Minetest Definition Ripper

You're making a puzzle/adventure game, and you need building materials for the scenery.  It's a bother to make all original artwork, or you like the look and feel of something that already exists, but it comes with all this extra functionality that you don't want...

This mod will allow you to export the "superficial" definitions and media for selected items.  Add the mod to a game that has all the things loaded that you want to export, instruct the mod which items to export (using chat commands), and it will dump the start of a mod that can be used to import item registrations into your game.

You will get a folder in your worldpath containing a skeletal mod:

- All media files referenced by the items, split into textures/sounds/models.
- An `exported.lua` file with each definition.

You will need to provide your own `init.lua`, `mod.conf` and other infrastructure, but the exported definitions are kept in a separate file so you can safely overwrite it later (e.g. if you add definitions) without destroying your custom logic.

`exported.lua` takes a register_item-like function as a file-level parameter.  This function will receive a single parameter with the definition table; it does NOT get an item name.  There is a `_raw_name` key inside the definition from which you will need to derive your own name in a manner you deem appropriate (you have an opportunity to customize before registration here).

Example:
```lua
local modname = minetest.get_current_modname()
loadfile(minetest.get_modpath(modname) .. "/exported.lua")(function(def)
	local myname = modname .. ":" .. def._raw_name:gsub(":", "__")
	def._raw_name = nil
	minetest.register_item(myname, def)
end)
```

## Licensing Warning

You are still responsible for complying with licensing for all media files in the export.  This includes:

- Tracing the origin of each file (the names should match, and be unique in any sane setup) and identifying the author and original license.
- Including attribution/credit in your resultant project.
- Complying with sublicensing requirements when selecting the license for your own projet containing these media.
- Anything else required by the license that applies to any file you use.

This tool may also rip media from "private" mods you might have installed, including things you don't actually have the right to redistribute; you are responsible for manually ensuring these are not included in any product you create using this tool.